/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public abstract class ExportFormatAbstract
implements ExportFormat {
    private String _formatName;
    private FileFilter _fileFilter;

    public ExportFormatAbstract(String name, FileFilter fileFilter) {
        this.setFormatName(name);
        this.setFileFilter(fileFilter);
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
        assert (this.fileFilter() != null) : "Failure in ExportFormatAbstract: fileFilter() == null";
        assert (this.fileFilter().equals(fileFilter)) : "Failure in ExportFormatAbstract: fileFilter() != fileFilter";
    }

    protected void setFormatName(String formatName) {
        this._formatName = formatName;
        assert (this.formatName() != null) : "Failure in ExportFormatAbstract: formatName() == null";
        assert (this.formatName().equals(formatName)) : "Failure in ExportFormatAbstract: formatName() != fielFilter";
    }

    @Override
    public FileFilter fileFilter() {
        FileFilter result = null;
        result = this._fileFilter;
        assert (result != null) : "Failure in ExportFormatAbstract: result == null";
        return result;
    }

    @Override
    public String formatName() {
        String result = null;
        result = this._formatName;
        assert (result != null) : "Failure in ExportFormatAbstract: result == null";
        return result;
    }

    @Override
    public File[] exportAll(Drawing[] drawings, File[] path) throws Exception {
        File[] result = null;
        if (drawings != null && path != null && drawings.length == path.length) {
            result = new File[path.length];
            for (int pos = 0; pos < drawings.length; ++pos) {
                result[pos] = this.export(drawings[pos], path[pos]);
            }
        }
        assert (result != null) : "Failure in ExportFormatAbstract : result == null";
        return result;
    }

    @Override
    public ExportFormat[] canExport(File path) {
        ExportFormat[] result = null;
        if (path != null) {
            result = this.fileFilter().accept(path) ? new ExportFormat[]{this} : new ExportFormat[]{};
        }
        assert (result != null) : "Failure in ExportFormatAbstract: result == null";
        return result;
    }

    @Override
    public int getShortCut() {
        return -1;
    }

    @Override
    public int getModifier() {
        return -1;
    }

    @Override
    public boolean forceGivenName() {
        return false;
    }

    public String toString() {
        return this.formatName();
    }
}

