/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseAttributeCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JColorChooser;

public class ChooseColorCommand
extends ChooseAttributeCommand {
    private JColorChooser chooser;

    public ChooseColorCommand(String displayName, String name, String attributeName, Class<?> type) {
        super(displayName, name, attributeName, type);
    }

    @Override
    protected void specializeDialog() {
        this.chooser = new JColorChooser();
        this.dialog.getContentPane().add((Component)this.chooser, "Center");
        this.dialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ChooseColorCommand.this.apply();
                } else if (e.getKeyCode() == 27) {
                    ChooseAttributeCommand.closeDialog(ChooseColorCommand.this.dialog);
                }
            }
        });
        this.dialog.pack();
    }

    @Override
    protected void updateFromFigure() {
        DrawingView view = this.getEditor().view();
        Object value = null;
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            Object val = f.getAttribute(this.fAttribute);
            if (val == null) continue;
            if (value != null && !value.equals(val)) {
                value = null;
                break;
            }
            value = val;
        }
        if (value != null && value instanceof Color) {
            this.chooser.setColor((Color)value);
        }
    }

    @Override
    protected void apply() {
        Color value = null;
        value = this.chooser.getColor();
        new ChangeAttributeCommand("", this.fAttribute, value).execute();
    }
}

