/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.SelectCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.ReplaceCommand;
import CH.ifa.draw.standard.SearchCommand;
import CH.ifa.draw.standard.UndoRedoCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenuItem;

public class EditMenuCreator {
    public Collection<JMenuItem> createMenus() {
        MenuManager.SeparatorFactory sepFac = new MenuManager.SeparatorFactory("ch.ifa.draw");
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        result.add(this.createCommandMenuItem(new UndoRedoCommand("Undo", UndoRedoCommand.Mode.UNDO), 90));
        result.add(this.createCommandMenuItem(new UndoRedoCommand("Redo", UndoRedoCommand.Mode.REDO), 89));
        result.add(sepFac.createSeparator());
        result.add(this.createCommandMenuItem(new CutCommand("Cut"), 88));
        result.add(this.createCommandMenuItem(new CopyCommand("Copy"), 67));
        result.add(this.createCommandMenuItem(new PasteCommand("Paste"), 86));
        result.add(sepFac.createSeparator());
        result.add(this.createCommandMenuItem(new DuplicateCommand("Duplicate"), 68));
        result.add(this.createCommandMenuItem(new DeleteCommand("Delete")));
        result.add(sepFac.createSeparator());
        result.add(this.createCommandMenuItem(new SearchCommand("Search..."), 70));
        result.add(this.createCommandMenuItem(new ReplaceCommand("Search & Replace..."), 71));
        result.add(sepFac.createSeparator());
        result.add(this.createCommandMenuItem(new GroupCommand("Group")));
        result.add(this.createCommandMenuItem(new UngroupCommand("Ungroup")));
        result.add(sepFac.createSeparator());
        result.add(this.createCommandMenuItem(new SelectCommand("Select All"), 65));
        result.add(this.createCommandMenuItem(new SelectCommand("Invert Selection", Figure.class, 4)));
        return result;
    }

    private CommandMenuItem createCommandMenuItem(Command command) {
        return new CommandMenuItem(command);
    }

    private CommandMenuItem createCommandMenuItem(Command command, int shortcut) {
        return new CommandMenuItem(command, shortcut);
    }
}

