/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.NullDrawingEditor;

public class SetLineWidthCommand
extends UndoableCommand {
    private int fWidth;

    public SetLineWidthCommand(String name, int i) {
        super(name);
        this.fWidth = i;
    }

    @Override
    protected boolean executeUndoable() {
        DrawingView view = this.getEditor().view();
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            f.setAttribute("LineWidth", this.fWidth);
        }
        view.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }
}

