/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.AbstractFileDragDropListener;
import CH.ifa.draw.application.DrawingViewContainer;
import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.figures.ImageFigureCreationTool;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TargetTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.Toolbar;
import CH.ifa.draw.framework.UndoRedoManager;
import CH.ifa.draw.gui.ToolButtonPanel;
import CH.ifa.draw.gui.ToolButtonScrollPane;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.DrawingLayoutWrapper;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.ScribbleOptionPanel;
import CH.ifa.draw.standard.SelectionChangeListener;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.StandardDrawingLookup;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.StandardDrawingViewContainer;
import CH.ifa.draw.standard.StandardDrawingViewFactory;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.standard.UndoableTool;
import CH.ifa.draw.util.AutosaveManager;
import CH.ifa.draw.util.AutosaveSaver;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.PaletteListener;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import de.renew.windowmanagement.RenewShutdownHook;
import de.renew.windowmanagement.UnknownMenuSectionException;
import de.renew.windowmanagement.Workbench;
import de.renew.windowmanagement.WorkbenchImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class StandardDrawingEditor
implements DrawingEditor,
PaletteListener,
CControlListener,
CFocusListener,
AutosaveSaver,
StatusDisplayer {
    public static Logger logger = Logger.getLogger(StandardDrawingEditor.class);
    private static final String fgDrawPath = "CH/ifa/draw/";
    public static final String IMAGES = "CH/ifa/draw/images/";
    private static final int AUTOSAVE_INTERVAL = 120000;
    public AutosaveManager autosaveManager = new AutosaveManager(this, 120000L);
    public static final String FACTORY_ID = "StandardDrawingViewFactory";
    private final Map<Class, String> factoryIDLookup = new LinkedHashMap<Class, String>();
    private StandardDrawingLookup fLookup;
    private ToolButton fCurrentToolButton;
    private ToolButton fDefaultToolButton;
    private UndoRedoManager fUndoRedoManager;
    protected Workbench fWorkbench;
    private StandardDrawingViewFactory fFactory;
    private List<SelectionChangeListener> fSelectionChangeListeners = new ArrayList<SelectionChangeListener>();
    private ToolButton fTextTB;
    private ToolButton fConnTextTB;
    private boolean fStickyTools = false;
    private ToolButtonScrollPane _toolbar;

    public StandardDrawingEditor(Workbench workbench) {
        this.fCurrentToolButton = this.fDefaultToolButton = this.createToolButton("CH/ifa/draw/images/SEL", "Selection Tool", this.createSelectionTool());
        this.fUndoRedoManager = new UndoRedoManager(this);
        this.fLookup = new StandardDrawingLookup();
        this.fWorkbench = workbench;
        this.fWorkbench.registerControlListener((CControlListener)this);
        this.fWorkbench.registerFocusListener((CFocusListener)this);
        this.fFactory = new StandardDrawingViewFactory(this);
        this.fWorkbench.registerEditorFactory((MultipleCDockableFactory)this.fFactory, FACTORY_ID);
        this._toolbar = new ToolButtonScrollPane(new ToolButtonPanel());
        this._toolbar.setAutoscrolls(true);
        this._toolbar.setHorizontalScrollBarPolicy(31);
        this._toolbar.setVerticalScrollBarPolicy(22);
        this.fWorkbench.addViewWindow(new DefaultSingleCDockable("Tools", (Component)((Object)this._toolbar), new CAction[0]), WorkbenchImpl.UPPER_LEFT_GROUP);
        this.createToolPanel();
        this.fWorkbench.registerShutdownHook(new RenewShutdownHook(){

            public boolean canClose() {
                StandardDrawingEditor.this._toolbar.saveLayout("Last Layout");
                StandardDrawingEditor.this._toolbar.storeLayoutsToDisk();
                return true;
            }

            public void exit() {
            }
        });
        AbstractFileDragDropListener dragDropListener = new AbstractFileDragDropListener(){

            @Override
            protected void handleFilesDrawing(File[] files, Point loc) {
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    StandardDrawingEditor.this.openOrLoadDrawing(file);
                }
            }

            @Override
            protected void handleFilesImage(File[] files, Point loc) {
                if (files.length >= 1) {
                    Vector<Figure> imagesToAdd = new Vector<Figure>();
                    DrawingView view = StandardDrawingEditor.this.view();
                    for (File file : files) {
                        Image image = ImageFigureCreationTool.createImage(file.getAbsolutePath(), StandardDrawingEditor.this.fWorkbench.getMainFrame());
                        ImageFigure imageFigure = new ImageFigure(image, file.getAbsolutePath(), loc);
                        Rectangle displayBox = imageFigure.displayBox();
                        imageFigure.moveBy(-(displayBox.width / 2), -(displayBox.height / 2));
                        imagesToAdd.add(imageFigure);
                    }
                    view.addAll(imagesToAdd);
                    view.checkDamage();
                }
            }
        };
        new DropTarget(this.fWorkbench.getMainFrame(), dragDropListener);
    }

    public void registerSelectionChangeListener(SelectionChangeListener listener) {
        this.fSelectionChangeListeners.add(listener);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    private void createToolPanel() {
        LinkedHashSet<AbstractButton> set = new LinkedHashSet<AbstractButton>();
        set.add(this.fDefaultToolButton.button());
        UndoableTool tool = new CreationTool(this, new RectangleFigure());
        ToolButton button = this.createToolButton("CH/ifa/draw/images/RECT", "Rectangle Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(tool.initialAttributesMenu());
        tool = new CreationTool(this, new RoundRectangleFigure());
        button = this.createToolButton("CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(tool.initialAttributesMenu());
        tool = new CreationTool(this, new EllipseFigure());
        button = this.createToolButton("CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(tool.initialAttributesMenu());
        tool = new CreationTool(this, new PieFigure());
        button = this.createToolButton("CH/ifa/draw/images/PIE", "Elliptical Arc/Pie Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(tool.initialAttributesMenu());
        tool = new CreationTool(this, new DiamondFigure());
        button = this.createToolButton("CH/ifa/draw/images/DIAMOND", "Diamond Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(tool.initialAttributesMenu());
        tool = new CreationTool(this, new TriangleFigure());
        button = this.createToolButton("CH/ifa/draw/images/TRIANGLE", "Triangle Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(tool.initialAttributesMenu());
        tool = new CreationTool(this, new LineFigure());
        button = this.createToolButton("CH/ifa/draw/images/LINE", "Line Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(tool.initialAttributesMenu());
        tool = new ConnectionTool(this, new LineConnection());
        button = this.createToolButton("CH/ifa/draw/images/CONN", "Connection Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(new JMenuItem("Test"));
        button.setAlternativeMode(0);
        tool = new ConnectionTool(this, new ElbowConnection());
        button = this.createToolButton("CH/ifa/draw/images/OCONN", "Elbow Connection Tool", tool);
        set.add(button.button());
        tool = new ScribbleTool(this);
        button = this.createToolButton("CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool);
        set.add(button.button());
        button.addAdditionalComponent(new ScribbleOptionPanel((ScribbleTool)tool));
        tool = new PolygonTool(this);
        button = this.createToolButton("CH/ifa/draw/images/POLYGON", "Polygon Tool", tool);
        set.add(button.button());
        tool = new ImageFigureCreationTool((DrawingEditor)this, this.fWorkbench.getMainFrame());
        button = this.createToolButton("CH/ifa/draw/images/IMAGE", "Image Tool", tool);
        set.add(button.button());
        TextFigure prototype = new TextFigure(false);
        prototype.setAlignment(0);
        tool = new TextTool((DrawingEditor)this, prototype);
        this.fTextTB = this.createToolButton("CH/ifa/draw/images/TEXT", "Text Tool", tool);
        set.add(this.fTextTB.button());
        prototype = new TextFigure();
        prototype.setAlignment(1);
        tool = new ConnectedTextTool((DrawingEditor)this, prototype);
        this.fConnTextTB = this.createToolButton("CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool);
        set.add(this.fConnTextTB.button());
        tool = new TargetTool(this);
        button = this.createToolButton("CH/ifa/draw/images/TARGETTEXT", "Target Tool", tool);
        set.add(button.button());
        String description = "<html><b>Standard Tools</b><br>The standard drawing tools<br>used to create basic shapes.</html>";
        this._toolbar.addTools(set, "Standard Tools", description);
    }

    @Override
    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    public ToolButton createToolButton(Icon icon, Icon selectedIcon, String toolName, Tool tool) {
        logger.debug((Object)("the delegator is " + String.valueOf(this)));
        return new ToolButton(this, icon, selectedIcon, toolName, tool);
    }

    public void setDrawingViewFactory(StandardDrawingViewFactory factory, String factoryID) {
        this.fFactory = factory;
        this.fWorkbench.registerEditorFactory((MultipleCDockableFactory)factory, factoryID);
    }

    @Override
    public DrawingView view() {
        DrawingView view = this.fLookup.getCurrentView();
        if (view != null) {
            return view;
        }
        return NullDrawingView.INSTANCE;
    }

    @Override
    public DrawingView previousView() {
        return this.fLookup.getPreviousView();
    }

    @Override
    public Drawing drawing() {
        return this.view().drawing();
    }

    @Override
    public Tool tool() {
        return this.fCurrentToolButton.tool();
    }

    @Override
    public Tool defaultTool() {
        return this.fDefaultToolButton.tool();
    }

    @Override
    public void setStickyTools(boolean sticky) {
        this.fStickyTools = sticky;
    }

    @Override
    public boolean isStickyTools() {
        return this.fStickyTools;
    }

    @Override
    public Image getIconImage() {
        Image icon = this.fWorkbench.getMainFrame().getIconImage();
        assert (icon != null) : "Icon of mainframe may not be null.";
        return icon;
    }

    @Override
    public void dispatchEvent(KeyEvent evt) {
        this.fWorkbench.getMainFrame().dispatchEvent(evt);
    }

    public ToolButton toolButtonForTextFigure(TextFigure figure) {
        if (figure.parent() == null) {
            return this.fTextTB;
        }
        return this.fConnTextTB;
    }

    @Override
    public void toolDone() {
        if (this.isStickyTools() && this.tool() != null) {
            this.tool().deactivate();
            this.tool().activate();
        } else if (this.fDefaultToolButton != null) {
            this.setToolButton(this.fDefaultToolButton);
        }
    }

    @Override
    public void selectionChanged(DrawingView view) {
        this.menuStateChanged();
        for (SelectionChangeListener listener : this.fSelectionChangeListeners) {
            listener.selectionStateChanged();
        }
    }

    @Override
    public void menuStateChanged() {
        JFrame frame = this.fWorkbench.getMainFrame();
        if (frame != null) {
            JMenuBar mb = frame.getJMenuBar();
            int count = mb.getMenuCount();
            for (int i = 0; i < count; ++i) {
                JMenu menu = mb.getMenu(i);
                if (!(menu instanceof CommandMenu)) continue;
                ((CommandMenu)menu).checkEnabled();
                ((CommandMenu)menu).updateCommandText();
            }
        }
    }

    @Override
    public void showStatus(String string) {
        this.fWorkbench.showStatus(string);
    }

    @Override
    public void prepareUndoSnapshot() {
        Drawing currentDrawing = this.drawing();
        this.fUndoRedoManager.prepareUndoSnapshot(currentDrawing);
    }

    @Override
    public void commitUndoSnapshot() {
        Drawing currentDrawing = this.drawing();
        this.fUndoRedoManager.commitUndoSnapshot(currentDrawing);
    }

    @Override
    public void prepareAccumulatedUndoSnapshot() {
        Drawing currentDrawing = this.drawing();
        this.fUndoRedoManager.prepareAccumulatedUndoSnapshot(currentDrawing);
    }

    @Override
    public void triggerAccumulatedUndoSnapshot() {
        Drawing currentDrawing = this.drawing();
        this.fUndoRedoManager.triggerAccumulatedUndoSnapshot(currentDrawing);
    }

    @Override
    public UndoRedoManager getUndoRedoManager() {
        return this.fUndoRedoManager;
    }

    @Override
    public void drawingViewContainerActivated(DrawingViewContainer viewContainer) {
    }

    @Override
    public void drawingViewContainerClosing(DrawingViewContainer viewContainer) {
    }

    @Override
    public void setCurrentDrawing(DrawingViewContainer dvc) {
    }

    @Override
    public void paletteUserSelected(ToolButton button, boolean doubleclick) {
        this.setToolButton(button);
        this.fStickyTools = doubleclick;
        this.showStatus("Selected tool: " + button.name());
    }

    private void setToolButton(ToolButton button) {
        assert (button != null);
        ToolButton.ToolButtonModel model = (ToolButton.ToolButtonModel)this.fCurrentToolButton.button().getModel();
        model.setTrulySelected(false);
        this.fCurrentToolButton.tool().deactivate();
        this.fCurrentToolButton = button;
        model = (ToolButton.ToolButtonModel)button.button().getModel();
        model.setTrulySelected(true);
        button.tool().activate();
    }

    @Override
    public void paletteUserOver(ToolButton button, boolean inside) {
    }

    public void added(CControl cControl, CDockable cDockable) {
        if (cDockable instanceof StandardDrawingViewContainer) {
            logger.debug((Object)"Dockable of type StandardDrawingViewContainer was added.");
            StandardDrawingViewContainer container = (StandardDrawingViewContainer)cDockable;
            Drawing drawing = container.getView().drawing();
            this.fLookup.addViewContainer(drawing, container);
            this.fUndoRedoManager.newUndoHistory(drawing);
        }
    }

    public void removed(CControl cControl, CDockable cDockable) {
        if (cDockable instanceof StandardDrawingViewContainer) {
            logger.debug((Object)"Dockable of type StandardDrawingViewContainer was removed.");
            StandardDrawingViewContainer container = (StandardDrawingViewContainer)cDockable;
            Drawing drawing = container.getView().drawing();
            this.fLookup.removeViewContainer(drawing);
            this.noUndoHistoryFor(drawing);
            if (this.fLookup.getCurrentView() == container.getView()) {
                this.fLookup.setCurrentView(NullDrawingView.INSTANCE);
                this.selectionChanged(null);
            }
        }
    }

    public void opened(CControl cControl, CDockable cDockable) {
    }

    public void closed(CControl cControl, CDockable cDockable) {
    }

    public void focusGained(CDockable cDockable) {
        if (cDockable instanceof StandardDrawingViewContainer) {
            logger.debug((Object)(((StandardDrawingViewContainer)cDockable).getView().drawing().getName() + " gained focus."));
            StandardDrawingViewContainer container = (StandardDrawingViewContainer)cDockable;
            this.fLookup.setCurrentView(container.getView());
            this.selectionChanged(container.getView());
        }
    }

    public void focusLost(CDockable cDockable) {
    }

    public Drawing openDrawing(Drawing drawing) {
        assert (drawing != null) : "Drawing may not be null.";
        StandardDrawingViewContainer container = this.fLookup.getViewContainerForDrawing(drawing);
        if (container != null) {
            if (!this.fLookup.getCurrentView().drawing().equals(drawing)) {
                container.toFront();
            }
        } else {
            this.createNewViewContainerForDrawing(drawing);
            container = this.fLookup.getViewContainerForDrawing(drawing);
            if (container != null) {
                container.toFront();
            }
        }
        return drawing;
    }

    protected void createNewViewContainerForDrawing(Drawing drawing) {
        String id = this.factoryIDLookup.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(drawing)).reduce((e1, e2) -> ((Class)e2.getKey()).isAssignableFrom((Class)e1.getKey()) ? e1 : e2).map(Map.Entry::getValue).orElse(FACTORY_ID);
        this.fWorkbench.addEditorWindow((MultipleCDockableLayout)new DrawingLayoutWrapper(drawing), id);
    }

    @Override
    public void openOrLoadDrawing(File file, DrawingView view) {
        Drawing drawing = this.fLookup.getLoadedDrawingForFile(file);
        if (drawing != null) {
            this.openDrawing(drawing);
        } else {
            this.getIOHelper().loadAndOpenDrawings(file);
        }
        Runnable r = () -> {
            Drawing drawing1 = this.fLookup.getLoadedDrawingForFile(file);
            StandardDrawingViewContainer container = this.fLookup.getViewContainerForDrawing(drawing1);
            container.setLocationsAside((CDockable)this.fLookup.getViewContainerForDrawing(view.drawing()));
        };
        EventQueue.invokeLater(r);
    }

    @Override
    public void openOrLoadDrawing(File file) {
        Drawing drawing = this.fLookup.getLoadedDrawingForFile(file);
        if (drawing != null) {
            this.openDrawing(drawing);
        } else {
            this.getIOHelper().loadAndOpenDrawings(file);
        }
    }

    public void closeDrawing(Drawing drawing) {
        StandardDrawingViewContainer container = this.fLookup.getViewContainerForDrawing(drawing);
        if (container == null) {
            return;
        }
        try {
            if (EventQueue.isDispatchThread()) {
                this.fWorkbench.close((MultipleCDockable)container);
            } else {
                EventQueue.invokeAndWait(() -> this.fWorkbench.close((MultipleCDockable)container));
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.error((Object)("Unable to close drawing due to exception: " + String.valueOf(e)));
        }
        if (!container.isVisible()) {
            this.fLookup.removeViewContainer(drawing);
        }
    }

    public Drawing newDrawing() {
        Drawing drawing = this.fFactory.create().drawing();
        return this.openDrawing(drawing);
    }

    @Override
    public void saveAutosaveFile(Drawing drawing, File file, Point loc, Dimension size) throws IOException {
        DrawingFileHelper.saveAsStorableOutput(drawing, file, loc, size, false);
    }

    protected void noUndoHistoryFor(Drawing drawing) {
        this.fUndoRedoManager.removeUndoHistory(drawing);
    }

    public void addMenu(JMenu menu) {
        this.fWorkbench.registerMenu(menu);
    }

    public void addMenu(JMenu menu, int index) {
        try {
            this.fWorkbench.registerMenu(menu, index);
        }
        catch (UnknownMenuSectionException e) {
            e.printStackTrace();
        }
    }

    public void removeMenu(JMenu menu) {
        this.fWorkbench.removeMenu(menu);
    }

    public DrawingView getView(Drawing drawing) {
        StandardDrawingViewContainer container = this.fLookup.getViewContainerForDrawing(drawing);
        if (container == null) {
            return null;
        }
        StandardDrawingView view = container.getView();
        assert (view != null);
        return view;
    }

    public StandardDrawingLookup getDrawingLookup() {
        return this.fLookup;
    }

    private IOHelper getIOHelper() {
        return DrawPlugin.getCurrent().getIOHelper();
    }

    private ImportHolder getImportHolder() {
        return DrawPlugin.getCurrent().getImportHolder();
    }

    private boolean canOpen(URI path) {
        ImportFormat[] allImportFormats;
        for (SimpleFileFilter filter : this.getIOHelper().getFileFilter().getFileFilters()) {
            if (!filter.accept(new File(path.getPath()))) continue;
            return true;
        }
        for (ImportFormat importFormat : allImportFormats = this.getImportHolder().allImportFormats()) {
            if (!importFormat.canImport(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doTextEdit(TextFigure textFigure) {
        this.doTextEdit(textFigure, 0, 0, 0, 0);
    }

    public void doTextEdit(TextFigure textFigure, int startLine, int startColumn, int endLine, int endColumn) {
        ToolButton tb = this.toolButtonForTextFigure(textFigure);
        this.paletteUserSelected(tb, false);
        TextTool tt = (TextTool)tb.tool();
        tt.beginEdit(textFigure);
        if (startLine < endLine || startLine == endLine && startColumn < endColumn) {
            tt.select(startLine, startColumn, endLine, endColumn);
        } else if (startLine > 0 && startColumn > 0) {
            tt.setCaretPosition(startLine, startColumn);
        }
    }

    public synchronized void loadAndInsertDrawing(File file) {
        Drawing existingDrawing = this.drawing();
        DrawingView existingView = this.view();
        Drawing newDrawing = DrawingFileHelper.loadDrawing(file, null);
        if (newDrawing != null) {
            FigureEnumeration figures = newDrawing.figures();
            existingView.clearSelection();
            while (figures.hasMoreElements()) {
                Figure fig = figures.nextFigure();
                existingDrawing.add(fig);
                existingView.addToSelection(fig);
            }
            existingView.checkDamage();
        }
    }

    public void print() {
        this.fCurrentToolButton.tool().deactivate();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.view());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(this.fWorkbench.getMainFrame(), "Printing of this Drawing failed.\nReason: " + e.getMessage(), "Printer Error", 0);
            }
        }
        this.fCurrentToolButton.tool().activate();
    }

    public void closeCurrentDrawing() {
        Drawing drawing = this.drawing();
        StandardDrawingViewContainer container = this.fLookup.getViewContainerForDrawing(drawing);
        this.fWorkbench.close((MultipleCDockable)container);
    }

    @Override
    public void registerDrawingViewFactoryID(Class key, String id) {
        this.factoryIDLookup.put(key, id);
    }
}

