/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.AbstractFileDragDropListener;
import CH.ifa.draw.figures.CompositeAttributeFigure;
import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.figures.ImageFigureCreationTool;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.FigureWithDependencies;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.ContextGraphics;
import CH.ifa.draw.util.Geom;
import bibliothek.gui.DockUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class StandardDrawingView
extends JPanel
implements DrawingView,
FigureChangeListener,
MouseListener,
MouseWheelListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = -3878153366174603336L;
    private static Logger logger = Logger.getLogger(StandardDrawingView.class);
    private transient DrawingEditor fEditor;
    private Drawing fDrawing;
    private transient Rectangle fDamage = null;
    private transient Vector<Figure> fSelection;
    private transient Vector<Handle> fSelectionHandles;
    private transient Object selectionHandlesLock = new Object();
    private Dimension fViewSize;
    private Point fLastClick;
    private Vector<Painter> fBackgrounds = null;
    private Vector<Painter> fForegrounds = null;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    private int drawingViewSerializedDataVersion = 1;
    private transient Object repaintLock = new Object();
    private double scaleFactor = 1.0;
    private final double maxScaling = 3.0;
    private final double minScaling = 0.2;
    private AffineTransform fAffineTransform;

    public StandardDrawingView(DrawingEditor editor, int width, int height) {
        this.fEditor = editor;
        this.fViewSize = new Dimension(width, height);
        this.fLastClick = new Point(0, 0);
        this.fConstrainer = null;
        this.fSelection = new Vector();
        this.setDisplayUpdate(new SimpleUpdateStrategy());
        this.setBackground(Color.lightGray);
        this.setOpaque(true);
        this.setLayout(null);
        this.fAffineTransform = AffineTransform.getScaleInstance(1.0, 1.0);
        AbstractFileDragDropListener dragDropListener = new AbstractFileDragDropListener(){

            @Override
            protected void handleFilesDrawing(File[] files, Point loc) {
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    StandardDrawingView.this.fEditor.openOrLoadDrawing(file, StandardDrawingView.this);
                }
            }

            @Override
            protected void handleFilesImage(File[] files, Point loc) {
                if (files.length >= 1) {
                    Vector<Figure> imagesToAdd = new Vector<Figure>();
                    for (File file : files) {
                        Image image = ImageFigureCreationTool.createImage(file.getAbsolutePath(), StandardDrawingView.this);
                        Point p = StandardDrawingView.this.constrainPoint(new Point(loc.x, loc.y));
                        StandardDrawingView.this.inverseTransformPoint(p);
                        ImageFigure imageFigure = new ImageFigure(image, file.getAbsolutePath(), p);
                        Rectangle displayBox = imageFigure.displayBox();
                        imageFigure.moveBy(-(displayBox.width / 2), -(displayBox.height / 2));
                        imagesToAdd.add(imageFigure);
                    }
                    StandardDrawingView.this.addAll(imagesToAdd);
                    StandardDrawingView.this.checkDamage();
                }
            }
        };
        new DropTarget(this, dragDropListener);
    }

    @Override
    public void setEditor(DrawingEditor editor) {
        this.fEditor = editor;
    }

    @Override
    public Tool tool() {
        return this.fEditor.tool();
    }

    @Override
    public Drawing drawing() {
        return this.fDrawing;
    }

    @Override
    public void setDrawing(Drawing d) {
        if (this.fDrawing != null) {
            this.clearSelection();
            this.fDrawing.removeDrawingChangeListener(this);
        }
        this.fDrawing = d;
        this.fDrawing.addDrawingChangeListener(this);
        this.checkMinimumSize(null);
        this.repaint();
    }

    @Override
    public DrawingEditor editor() {
        return this.fEditor;
    }

    @Override
    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    @Override
    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    @Override
    public void addAll(Vector<Figure> figures) {
        FigureEnumerator k = new FigureEnumerator(figures);
        while (k.hasMoreElements()) {
            this.add(k.nextFigure());
        }
    }

    @Override
    public void removeAll(Vector<Figure> figures) {
        FigureEnumerator k = new FigureEnumerator((Vector)figures.clone());
        while (k.hasMoreElements()) {
            this.remove(k.nextFigure());
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension result = this.fViewSize;
        if (this.scaleFactor > 1.0 && this.fAffineTransform != null) {
            Rectangle r = this.fAffineTransform.createTransformedShape(new Rectangle(this.fViewSize.width, this.fViewSize.height)).getBounds();
            result = r.getSize();
        }
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void setDisplayUpdate(Painter updateStrategy) {
        this.fUpdateStrategy = updateStrategy;
    }

    @Override
    public Vector<Figure> selection() {
        return new Vector<Figure>(this.fSelection);
    }

    @Override
    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(this.selection());
    }

    @Override
    public Vector<Figure> inZOrder(Vector<Figure> selection) {
        Vector<Figure> result = new Vector<Figure>(selection.size());
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasMoreElements()) {
            Figure f = figures.nextFigure();
            if (!selection.contains(f)) continue;
            result.addElement(f);
        }
        return result;
    }

    @Override
    public Vector<Figure> selectionZOrdered() {
        return this.inZOrder(this.fSelection);
    }

    @Override
    public int selectionCount() {
        return this.fSelection.size();
    }

    @Override
    public void addToSelection(Figure figure) {
        if (this.addToSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    protected boolean addToSelectionInternal(Figure figure) {
        if (!this.fSelection.contains(figure) && figure.isSelectable()) {
            this.fSelection.addElement(figure);
            figure.addFigureChangeListener(this);
            this.selectionInvalidateHandles();
            figure.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void addToSelectionAll(Vector<Figure> figures) {
        this.addToSelectionAll(new FigureEnumerator(figures));
    }

    @Override
    public void addToSelectionAll(FigureEnumeration figures) {
        boolean changed = false;
        while (figures.hasMoreElements()) {
            changed |= this.addToSelectionInternal(figures.nextFigure());
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    @Override
    public void removeFromSelection(Figure figure) {
        if (this.removeFromSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    protected boolean removeFromSelectionInternal(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.fSelection.removeElement(figure);
            figure.removeFigureChangeListener(this);
            this.selectionInvalidateHandles();
            figure.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void removeFromSelectionAll(Vector<Figure> figures) {
        this.removeFromSelectionAll(new FigureEnumerator(figures));
    }

    @Override
    public void removeFromSelectionAll(FigureEnumeration figures) {
        boolean changed = false;
        while (figures.hasMoreElements()) {
            changed |= this.removeFromSelectionInternal(figures.nextFigure());
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.toggleSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    public boolean toggleSelectionInternal(Figure figure) {
        if (this.fSelection.contains(figure)) {
            return this.removeFromSelectionInternal(figure);
        }
        return this.addToSelectionInternal(figure);
    }

    @Override
    public void toggleSelectionAll(Vector<Figure> figures) {
        this.toggleSelectionAll(new FigureEnumerator(figures));
    }

    @Override
    public void toggleSelectionAll(FigureEnumeration figures) {
        boolean changed = false;
        while (figures.hasMoreElements()) {
            changed |= this.toggleSelectionInternal(figures.nextFigure());
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    @Override
    public void clearSelection() {
        FigureEnumeration k = this.selectionElements();
        while (k.hasMoreElements()) {
            Figure fig = k.nextFigure();
            fig.removeFigureChangeListener(this);
            fig.invalidate();
        }
        this.fSelection = new Vector();
        this.selectionInvalidateHandles();
        this.selectionChanged();
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        this.removeFromSelection(e.getFigure());
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionInvalidateHandles() {
        Object object = this.selectionHandlesLock;
        synchronized (object) {
            this.fSelectionHandles = null;
        }
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent e) {
        this.selectionInvalidateHandles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<Handle> selectionHandles() {
        Object object = this.selectionHandlesLock;
        synchronized (object) {
            if (this.fSelectionHandles == null) {
                this.fSelectionHandles = new Vector();
                FigureEnumeration k = this.selectionElements();
                while (k.hasMoreElements()) {
                    Figure figure = k.nextFigure();
                    Enumeration<Handle> kk = figure.handles().elements();
                    while (kk.hasMoreElements()) {
                        this.fSelectionHandles.addElement(kk.nextElement());
                    }
                }
            }
            return this.fSelectionHandles.elements();
        }
    }

    private static void tryAdd(Vector<Figure> vec, Figure obj) {
        if (obj != null && !vec.contains(obj)) {
            vec.addElement(obj);
        }
    }

    public static Vector<Figure> expandFigureVector(Vector<Figure> orgFigures) {
        Vector<Figure> figures = new Vector<Figure>(orgFigures);
        for (int i = 0; i < figures.size(); ++i) {
            Figure figure = figures.elementAt(i);
            if (!(figure instanceof FigureWithDependencies)) continue;
            FigureWithDependencies df = (FigureWithDependencies)figure;
            FigureEnumeration relatedFigures = df.getFiguresWithDependencies();
            while (relatedFigures.hasMoreElements()) {
                StandardDrawingView.tryAdd(figures, relatedFigures.nextFigure());
            }
        }
        return figures;
    }

    @Override
    public FigureSelection getFigureSelection() {
        return new FigureSelection(this.inZOrder(StandardDrawingView.expandFigureVector(this.fSelection)));
    }

    @Override
    public Handle findHandle(int x, int y) {
        Enumeration<Handle> k = this.selectionHandles();
        while (k.hasMoreElements()) {
            Handle handle = k.nextElement();
            if (!handle.containsPoint(x, y)) continue;
            return handle;
        }
        return null;
    }

    protected void selectionChanged() {
        this.fEditor.selectionChanged(this);
    }

    @Override
    public Point lastClick() {
        return this.fLastClick;
    }

    @Override
    public Point getCurrentMousePosition() {
        return this.getMousePosition();
    }

    @Override
    public void setConstrainer(PointConstrainer c) {
        this.fConstrainer = c;
    }

    @Override
    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    protected Point constrainPoint(Point p) {
        Dimension size = this.getSize();
        p.x = Geom.range(1, size.width, p.x);
        p.y = Geom.range(1, size.height, p.y);
        if (this.fConstrainer != null) {
            return this.fConstrainer.constrainPoint(p);
        }
        return p;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean rightclick;
        boolean bl = rightclick = (e.getModifiersEx() & 0x1800) != 0;
        if (this.tool() != this.editor().defaultTool() && rightclick && e.getClickCount() == 1) {
            this.editor().setStickyTools(false);
            this.tool().cancel();
        } else {
            this.requestFocus();
            Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
            this.inverseTransformPoint(p);
            this.fLastClick = new Point(e.getX(), e.getY());
            this.tool().mouseDown(e, p.x, p.y);
            this.checkDamage();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.inverseTransformPoint(p);
        this.tool().mouseDrag(e, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.inverseTransformPoint(p);
        this.tool().mouseMove(e, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.inverseTransformPoint(p);
        this.tool().mouseUp(e, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Point p = e.getPoint();
        if (e.getWheelRotation() > 0) {
            this.zoomOutFromPoint(p);
        } else {
            this.zoomInOnPoint(p);
        }
    }

    public void zoomInOnPoint(Point p) {
        double factor = Math.min(this.scaleFactor + 0.2, 3.0);
        BigDecimal bd = new BigDecimal(factor).setScale(1, RoundingMode.HALF_UP);
        this.zoomOnPoint(bd.doubleValue(), p);
    }

    public void zoomOutFromPoint(Point p) {
        double factor = Math.max(this.scaleFactor - 0.2, 0.2);
        BigDecimal bd = new BigDecimal(factor).setScale(1, RoundingMode.HALF_UP);
        this.zoomOnPoint(bd.doubleValue(), p);
    }

    public void zoomOnPoint(double factor, Point p) {
        JViewport viewport = (JViewport)this.getParent();
        Point portPos = viewport.getViewPosition();
        Point p2 = new Point(p.x + portPos.x, p.y + portPos.y);
        this.inverseTransformPoint(p2);
        this.changeScalingFactor(factor);
        this.fAffineTransform.transform(p2, p2);
        int xViewport = Math.max(p2.x - p.x, 0);
        int yViewport = Math.max(p2.y - p.y, 0);
        portPos = new Point(xViewport, yViewport);
        viewport.setViewPosition(portPos);
        this.drawingInvalidated(new DrawingChangeEvent(this.fDrawing, this.getBounds()));
        this.checkDamage();
        viewport.repaint();
    }

    public void zoomToFitView(Rectangle rectangle) {
        JViewport viewport = (JViewport)this.getParent();
        Dimension portSize = viewport.getSize();
        double factor = Math.min(Math.min(portSize.getWidth() / rectangle.getWidth(), portSize.getHeight() / rectangle.getHeight()), 3.0);
        this.changeScalingFactor(factor);
        Point rectangleCenter = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
        this.fAffineTransform.transform(rectangleCenter, rectangleCenter);
        int xViewport = Math.max(rectangleCenter.x - portSize.width / 2, 0);
        int yViewport = Math.max(rectangleCenter.y - portSize.height / 2, 0);
        Point portPos = new Point(xViewport, yViewport);
        viewport.setViewPosition(portPos);
        viewport.setViewPosition(portPos);
        this.drawingInvalidated(new DrawingChangeEvent(this.fDrawing, this.getBounds()));
        this.checkDamage();
        viewport.repaint();
    }

    public double getScalingFactor() {
        return this.scaleFactor;
    }

    public void changeScalingFactor(double newFactor) {
        this.scaleFactor = newFactor;
        this.fAffineTransform = AffineTransform.getScaleInstance(this.scaleFactor, this.scaleFactor);
        this.editor().showStatus("Zoom factor: " + Double.valueOf(newFactor * 100.0).intValue() + "%");
    }

    @Override
    public AffineTransform getAffineTransform() {
        return this.fAffineTransform;
    }

    private Point inverseTransformPoint(Point p) {
        if (this.fAffineTransform != null) {
            try {
                this.fAffineTransform.inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
            }
        }
        return p;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getExtendedKeyCode();
        if (code == 8 || code == 127) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Delete pressed"));
            }
            DeleteCommand cmd = new DeleteCommand("Delete");
            ((Command)cmd).execute();
        } else if (code == 40 || code == 38 || code == 39 || code == 37) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Arrow pressed"));
            }
            this.handleCursorKey(code, e.getModifiersEx());
            if (this.fSelection.size() > 0) {
                e.consume();
            }
        } else if ((e.getModifiersEx() & (Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40)) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && (code == 48 || code == 521 || code == 45)) {
            JViewport viewport = (JViewport)this.getParent();
            Point center = new Point(viewport.getWidth() / 2, viewport.getHeight() / 2);
            switch (code) {
                case 48: {
                    this.zoomOnPoint(1.0, center);
                    break;
                }
                case 521: {
                    this.zoomInOnPoint(center);
                    break;
                }
                case 45: {
                    this.zoomOutFromPoint(center);
                }
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Pushing KeyEvent to tool e: " + code + " , " + e.getKeyChar()));
            }
            this.tool().keyDown(e, code);
        }
        this.checkDamage();
    }

    protected void handleCursorKey(int key) {
        this.handleCursorKey(key, 0);
    }

    protected void handleCursorKey(int key, int modifiers) {
        int dx = 0;
        int dy = 0;
        int stepX = 1;
        int stepY = 1;
        if (this.fConstrainer != null) {
            stepX = this.fConstrainer.getStepX();
            stepY = this.fConstrainer.getStepY();
        }
        if ((modifiers & 0x40) != 0) {
            stepX *= 10;
            stepY *= 10;
        }
        switch (key) {
            case 40: {
                dy = stepY;
                break;
            }
            case 38: {
                dy = -stepY;
                break;
            }
            case 39: {
                dx = stepX;
                break;
            }
            case 37: {
                dx = -stepX;
            }
        }
        this.fEditor.prepareAccumulatedUndoSnapshot();
        this.moveSelection(dx, dy);
        this.fEditor.triggerAccumulatedUndoSnapshot();
    }

    public static void moveFigures(Vector<Figure> figureVector, int dx, int dy) {
        Vector<Figure> iteratorFigureVector = new Vector<Figure>(figureVector);
        for (Figure figure1 : figureVector) {
            if (!(figure1 instanceof CompositeAttributeFigure)) continue;
            iteratorFigureVector.removeAll(((CompositeAttributeFigure)figure1).getAttached());
        }
        FigureEnumerator figures = new FigureEnumerator(iteratorFigureVector);
        while (figures.hasMoreElements()) {
            Figure figure;
            Figure parent = figure = figures.nextFigure();
            while (parent != null) {
                if (parent instanceof ChildFigure) {
                    if ((parent = ((ChildFigure)parent).parent()) == null || !figureVector.contains(parent)) continue;
                    break;
                }
                parent = null;
            }
            if (parent != null) continue;
            figure.moveBy(dx, dy);
        }
    }

    @Override
    public void moveSelection(int dx, int dy) {
        Point p = new Point(dx, dy);
        StandardDrawingView.moveFigures(this.fSelection, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public synchronized void checkDamage() {
        Enumeration<DrawingChangeListener> each = this.drawing().drawingChangeListeners();
        while (each.hasMoreElements()) {
            DrawingChangeListener l = each.nextElement();
            if (!(l instanceof DrawingView)) continue;
            ((DrawingView)l).repairDamage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repairDamage() {
        Object object = this.repaintLock;
        synchronized (object) {
            if (this.fDamage != null) {
                Rectangle r = this.fDamage;
                if (this.fAffineTransform != null) {
                    r = this.fAffineTransform.createTransformedShape(this.fDamage).getBounds();
                }
                if (r.x + r.width > r.width || r.y + r.height > r.height) {
                    this.checkMinimumSize(r);
                }
                this.repaint(0L, r.x, r.y, r.width, r.height);
                this.fDamage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawingInvalidated(DrawingChangeEvent e) {
        Object object = this.repaintLock;
        synchronized (object) {
            Rectangle r = e.getInvalidatedRectangle();
            if (r != null) {
                if (this.fDamage == null) {
                    this.fDamage = r;
                } else {
                    this.fDamage.add(r);
                }
            }
        }
    }

    @Override
    public void drawingRequestUpdate(DrawingChangeEvent e) {
        this.repairDamage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.fUpdateStrategy.draw(g2, this);
        Object object = this.repaintLock;
        synchronized (object) {
            if (this.fDamage != null) {
                this.repaint(0L, this.fDamage.x, this.fDamage.y, this.fDamage.width, this.fDamage.height);
                this.fDamage = null;
            }
        }
    }

    @Override
    public void drawAll(Graphics g) {
        boolean isPrinting = g instanceof PrintGraphics;
        this.drawBackground(g);
        if (this.fBackgrounds != null && !isPrinting) {
            this.drawPainters(g, this.fBackgrounds);
        }
        ContextGraphics cg = new ContextGraphics((Graphics2D)g, this.getBackground());
        cg.scale(this.scaleFactor, this.scaleFactor);
        this.drawDrawing(cg);
        if (this.fForegrounds != null && !isPrinting) {
            this.drawPainters(g, this.fForegrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
        cg.scale(1.0 / this.scaleFactor, 1.0 / this.scaleFactor);
        if (this.fDrawing == this.fEditor.drawing()) {
            this.tool().draw(cg);
        }
    }

    @Override
    public void drawHandles(Graphics g) {
        Enumeration<Handle> k = this.selectionHandles();
        while (k.hasMoreElements()) {
            k.nextElement().draw(g);
        }
    }

    @Override
    public void drawDrawing(Graphics g) {
        this.fDrawing.draw(g);
    }

    @Override
    public void drawBackground(Graphics g) {
        Color color = this.getBackgroundColor();
        g.setColor(color);
        Rectangle bounds = this.getBounds();
        g.fillRect(0, 0, bounds.width, bounds.height);
    }

    protected Color getBackgroundColor() {
        Color color = DockUI.getColor((String)"dock.background");
        return color.brighter();
    }

    private void drawPainters(Graphics g, Vector<Painter> v) {
        for (int i = 0; i < v.size(); ++i) {
            v.elementAt(i).draw(g, this);
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new Vector(3);
        }
        this.fBackgrounds.addElement(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = new Vector(3);
        }
        this.fForegrounds.addElement(painter);
        this.repaint();
    }

    @Override
    public void freezeView() {
    }

    @Override
    public void unfreezeView() {
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fSelection = new Vector();
        this.selectionHandlesLock = new Object();
        this.repaintLock = new Object();
        if (this.fDrawing != null) {
            this.fDrawing.addDrawingChangeListener(this);
        }
    }

    private void checkMinimumSize(Rectangle area) {
        if (area == null) {
            area = this.fDrawing.getBounds();
        }
        Dimension d = new Dimension(area.x + area.width, area.y + area.height);
        if (this.fViewSize.height < d.height) {
            this.fViewSize.height = d.height + 10;
        }
        if (this.fViewSize.width < d.width) {
            this.fViewSize.width = d.width + 10;
        }
        Dimension guiSize = this.getSize();
        boolean changed = false;
        if (guiSize.width < this.fViewSize.width) {
            guiSize.width = this.fViewSize.width;
            changed = true;
        }
        if (guiSize.height < this.fViewSize.height) {
            guiSize.height = this.fViewSize.height;
            changed = true;
        }
        if (changed) {
            this.setSize(guiSize.width, guiSize.height);
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void showElement(Figure fig) {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JScrollPane); c = c.getParent()) {
        }
        if (c != null) {
            JScrollPane pane = (JScrollPane)c;
            Point p = fig.center();
            int x = p.x - pane.getWidth() / 2;
            int y = p.y - pane.getHeight() / 2;
            int vpWidth = pane.getViewport().getWidth();
            int vpHeight = pane.getViewport().getHeight();
            int vWidth = pane.getViewport().getView().getWidth();
            int vHeight = pane.getViewport().getView().getHeight();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x + vpWidth > vWidth) {
                x = vWidth - vpWidth;
            }
            if (y + vpHeight > vHeight) {
                y = vHeight - vpHeight;
            }
            pane.getViewport().setViewPosition(new Point(x, y));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        if (graphics instanceof Graphics2D) {
            double scale;
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double sH = pageFormat.getImageableHeight() / (double)this.getHeight();
            double sW = pageFormat.getImageableWidth() / (double)this.getWidth();
            double d = scale = sH > sW ? sW : sH;
            if (scale < 1.0) {
                g2.scale(scale, scale);
            }
            this.drawAll(graphics);
            return 0;
        }
        return 1;
    }
}

