/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingViewDecoration;
import CH.ifa.draw.standard.AttributeMenuDecoration;
import CH.ifa.draw.standard.DrawingLayoutWrapper;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.StandardDrawingViewContainer;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class StandardDrawingViewFactory
implements MultipleCDockableFactory<StandardDrawingViewContainer, DrawingLayoutWrapper> {
    protected StandardDrawingEditor fEditor;
    private List<DrawingViewDecoration> decorations = new LinkedList<DrawingViewDecoration>();
    public static Logger logger = Logger.getLogger(StandardDrawingViewFactory.class);

    public StandardDrawingViewFactory(StandardDrawingEditor editor) {
        this.fEditor = editor;
        AttributeMenuDecoration attributeMenuDecoration = new AttributeMenuDecoration();
        editor.registerSelectionChangeListener(attributeMenuDecoration);
        this.addDecoration(attributeMenuDecoration);
    }

    public DrawingLayoutWrapper write(StandardDrawingViewContainer standardDrawingViewContainer) {
        return new DrawingLayoutWrapper(standardDrawingViewContainer.getView().drawing());
    }

    public StandardDrawingViewContainer read(DrawingLayoutWrapper layout) {
        logger.debug((Object)"Creating a new view container for a drawing.");
        Drawing drawing = layout.drawing();
        StandardDrawingView view = this.createViewFromDrawing(drawing);
        view.setDrawing(drawing);
        StandardDrawingViewContainer container = new StandardDrawingViewContainer(this, view);
        container.setTitleText(drawing.getName());
        logger.debug((Object)"Adding additional decorations to view container.");
        this.addDecorations(container);
        return container;
    }

    protected StandardDrawingView createViewFromDrawing(Drawing drawing) {
        Dimension d = drawing.defaultSize();
        StandardDrawingView view = new StandardDrawingView(this.fEditor, d.width, d.height);
        return view;
    }

    public boolean match(StandardDrawingViewContainer standardDrawingViewContainer, DrawingLayoutWrapper layout) {
        Drawing drawing = layout.drawing();
        return standardDrawingViewContainer.getView().drawing().equals(drawing);
    }

    public DrawingLayoutWrapper create() {
        return new DrawingLayoutWrapper(new StandardDrawing());
    }

    public void addDecoration(DrawingViewDecoration decoration) {
        this.decorations.add(decoration);
    }

    protected void addDecorations(StandardDrawingViewContainer container) {
        for (DrawingViewDecoration decoration : this.decorations) {
            LinkedList<CAction> actions = decoration.getDecorations();
            for (CAction action : actions) {
                container.addAction(action);
            }
            container.addSeparator();
        }
    }
}

