/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.standard.GridConstrainer;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.GUIProperties;
import de.renew.plugin.PluginProperties;
import java.awt.Point;
import java.util.Properties;

public class ToggleGridCommand
extends Command {
    private Point fGrid;

    protected DrawingEditor getEditor() {
        DrawPlugin plugin = DrawPlugin.getCurrent();
        return plugin == null ? NullDrawingEditor.INSTANCE : plugin.getDrawingEditor();
    }

    public ToggleGridCommand(String name) {
        super(name);
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return super.isExecutable();
    }

    @Override
    public void execute() {
        DrawingView view = this.getEditor().view();
        PointConstrainer grid = view.getConstrainer();
        if (grid != null) {
            view.setConstrainer(null);
        } else {
            int size;
            DrawPlugin current = DrawPlugin.getCurrent();
            if (current == null) {
                Properties properties = GUIProperties.getProperties();
                size = ((PluginProperties)properties).getIntProperty("ch.ifa.draw.grid.size", 5);
            } else {
                size = current.getProperties().getIntProperty("ch.ifa.draw.grid.size", 5);
            }
            this.fGrid = new Point(size, size);
            view.setConstrainer(new GridConstrainer(this.fGrid.x, this.fGrid.y));
        }
    }
}

