/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import de.renew.util.Scheduler;
import java.awt.EventQueue;

public class AWTSynchronizedUpdate
implements Runnable {
    private boolean inUpdate = false;
    private boolean anotherTurn = false;
    private Runnable updateTask;
    private long updateDelay = 0L;
    private DelayingTask delayingTask;

    public AWTSynchronizedUpdate(Runnable updateTask) {
        this(0L, updateTask);
    }

    public AWTSynchronizedUpdate(long updateDelay, Runnable updateTask) {
        this.updateDelay = updateDelay;
        this.updateTask = updateTask;
        this.delayingTask = new DelayingTask(this);
    }

    public synchronized void scheduleUpdate() {
        this.anotherTurn = true;
        if (!this.inUpdate) {
            if (this.updateDelay == 0L) {
                EventQueue.invokeLater(this);
            } else {
                Scheduler.instance().executeIn((Runnable)this.delayingTask, this.updateDelay);
            }
            this.inUpdate = true;
        }
    }

    private synchronized boolean testAndResetUpdateRequest() {
        this.inUpdate = this.anotherTurn;
        this.anotherTurn = false;
        if (this.updateDelay == 0L) {
            return this.inUpdate;
        }
        if (this.inUpdate) {
            Scheduler.instance().executeIn((Runnable)this.delayingTask, this.updateDelay);
        }
        return false;
    }

    @Override
    public void run() {
        this.testAndResetUpdateRequest();
        do {
            this.updateTask.run();
        } while (this.testAndResetUpdateRequest());
    }

    private static class DelayingTask
    implements Runnable {
        private final AWTSynchronizedUpdate instance;

        public DelayingTask(AWTSynchronizedUpdate instance) {
            this.instance = instance;
        }

        @Override
        public void run() {
            EventQueue.invokeLater(this.instance);
        }
    }
}

