/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInOut;
import CH.ifa.draw.util.UnknownTypeException;
import de.renew.plugin.PluginManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.Logger;

public class StorableInput
extends StorableInOut {
    public static Logger logger = Logger.getLogger(StorableInput.class);
    private StreamTokenizer fTokenizer;
    private Reader fReader;
    private int version = Integer.MAX_VALUE;

    public StorableInput(URL location, boolean useUTF) throws IOException {
        this(URI.create(location.toString()), location.openStream(), useUTF);
    }

    public StorableInput(File file, boolean useUTF) throws FileNotFoundException {
        this(file.toURI(), new FileInputStream(file), useUTF);
    }

    public StorableInput(InputStream stream) {
        this(null, stream, true);
    }

    public StorableInput(InputStream stream, boolean useUTF) {
        this(null, stream, useUTF);
    }

    private StorableInput(URI location, InputStream stream, boolean useUTF) {
        super(location);
        if (useUTF) {
            try {
                this.fReader = new BufferedReader(new InputStreamReader(stream, "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"UTF-8 not supported!");
            }
        }
        if (this.fReader == null) {
            this.fReader = new BufferedReader(new InputStreamReader(stream));
        }
        this.fTokenizer = new StreamTokenizer(this.fReader);
        this.fTokenizer.wordChars(95, 95);
    }

    public StorableInput(String stringStream) {
        this(null, stringStream);
    }

    private StorableInput(URI location, String stringStream) {
        super(location);
        if (this.fReader == null) {
            this.fReader = new BufferedReader(new StringReader(stringStream));
        }
        this.fTokenizer = new StreamTokenizer(this.fReader);
        this.fTokenizer.wordChars(95, 95);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Storable readStorable() throws IOException {
        String s = this.readString();
        if (s.equals("NULL")) {
            return null;
        }
        if (s.equals("REF")) {
            int ref = this.readInt();
            return this.retrieve(ref);
        }
        Storable storable = (Storable)this.makeInstance(s);
        this.map(storable);
        storable.read(this);
        return storable;
    }

    public String readString() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -3 || token == 34) {
            return this.fTokenizer.sval;
        }
        String msg = "Expected String but found: " + String.valueOf(this.fTokenizer);
        throw new IOException(msg);
    }

    public boolean canReadInt() throws IOException {
        int token = this.fTokenizer.nextToken();
        this.fTokenizer.pushBack();
        return token == -2;
    }

    public int readInt() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval;
        }
        String msg = "Expected Integer but found: " + String.valueOf(this.fTokenizer);
        throw new IOException(msg);
    }

    public Color readColor() throws IOException {
        return new Color(this.readInt(), this.readInt(), this.readInt());
    }

    public double readDouble() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return this.fTokenizer.nval;
        }
        String msg = "Expected Double but found: " + String.valueOf(this.fTokenizer);
        throw new IOException(msg);
    }

    public boolean readBoolean() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval == 1;
        }
        String msg = "Expected Integer but found: " + String.valueOf(this.fTokenizer);
        throw new IOException(msg);
    }

    protected Object makeInstance(String className) throws IOException {
        try {
            ClassLoader classLoader = PluginManager.getInstance().getBottomClassLoader();
            Class<?> cl = Class.forName(className, true, classLoader);
            return cl.newInstance();
        }
        catch (NoSuchMethodError e) {
            throw new IOException("Class " + className + " does not seem to have a no-arg constructor", e);
        }
        catch (ClassNotFoundException e) {
            throw new UnknownTypeException("No class: " + className, className);
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot instantiate: " + className);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Class (" + className + ") not accessible");
        }
    }

    public void close() {
        try {
            this.fReader.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void putBack() {
        this.fTokenizer.pushBack();
    }
}

