/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.DelayedFieldOwner;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class DelayedField
implements Serializable {
    static final long serialVersionUID = -6231461074991131516L;
    private Object field;
    private DelayedFieldOwner owner;

    DelayedField(Object field, DelayedFieldOwner owner) {
        this.field = field;
        this.owner = owner;
    }

    void reassign() throws IOException {
        this.owner.reassignField(this.field);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream rout = null;
        if (out instanceof RenewObjectOutputStream) {
            rout = (RenewObjectOutputStream)out;
        }
        if (rout != null) {
            rout.beginDomain(this.owner);
        }
        out.defaultWriteObject();
        if (rout != null) {
            rout.endDomain(this.owner);
        }
    }

    public String toString() {
        return "DelayedField(owner:" + String.valueOf(this.owner) + ", value:" + String.valueOf(this.field) + ")";
    }
}

