/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.Value;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntegerRangeSet
extends AbstractSet<Value> {
    private final int first;
    private final int last;

    public IntegerRangeSet(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("(lower bound)" + first + " > " + last + " (upper  bound).");
        }
        this.first = first;
        this.last = last;
    }

    @Override
    public int size() {
        return this.last - this.first + 1;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Value) {
            Value v = (Value)o;
            if (v.value instanceof Integer) {
                int i = v.intValue();
                return this.first <= i && i <= this.last;
            }
        }
        return false;
    }

    @Override
    public Iterator<Value> iterator() {
        return new Iterator<Value>(){
            private int next;
            private boolean hasNext;
            {
                this.next = IntegerRangeSet.this.first;
                this.hasNext = true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Value next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = this.next != IntegerRangeSet.this.last;
                return new Value(this.next++);
            }
        };
    }
}

