/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

public class RandomBag {
    private Object[] elements = new Object[8];
    private int size = 0;

    public int size() {
        return this.size;
    }

    private void setCapacity(int capacity) {
        Object[] newElements = new Object[capacity];
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        this.elements = newElements;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.elements.length) {
            if (capacity < 2 * this.elements.length) {
                capacity = 2 * this.elements.length;
            }
            this.setCapacity(capacity);
        }
    }

    private void limitCapacity() {
        if (this.size >= 8 && this.size * 4 < this.elements.length) {
            this.setCapacity(this.size * 2);
        }
    }

    public void insert(Object elem) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = elem;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object extract() {
        if (this.isEmpty()) {
            return null;
        }
        Object elem = this.elements[this.size - 1];
        this.elements[this.size - 1] = null;
        --this.size;
        this.limitCapacity();
        return elem;
    }
}

