/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.ClassSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionSerializer {
    private ReflectionSerializer() {
    }

    public static void writeField(ObjectOutputStream out, Field field) throws IOException {
        if (field == null) {
            out.writeObject(null);
        } else {
            ReflectionSerializer.writeClass(out, field.getDeclaringClass());
            out.writeObject(field.getName());
        }
    }

    public static Field readField(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Class<?> clazz = ReflectionSerializer.readClass(in);
            if (clazz == null) {
                return null;
            }
            String name = (String)in.readObject();
            return clazz.getField(name);
        }
        catch (ClassCastException e) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Field: " + String.valueOf(e));
        }
        catch (NoSuchFieldException e) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Field: " + String.valueOf(e));
        }
    }

    public static void writeMethod(ObjectOutputStream out, Method method) throws IOException {
        if (method == null) {
            out.writeObject(null);
        } else {
            ReflectionSerializer.writeClass(out, method.getDeclaringClass());
            out.writeObject(method.getName());
            ReflectionSerializer.writeClassArray(out, method.getParameterTypes());
        }
    }

    public static Method readMethod(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Class<?> clazz = ReflectionSerializer.readClass(in);
            if (clazz == null) {
                return null;
            }
            String name = (String)in.readObject();
            Class<?>[] params = ReflectionSerializer.readClassArray(in);
            return clazz.getMethod(name, params);
        }
        catch (ClassCastException e) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Method: " + String.valueOf(e));
        }
        catch (NoSuchMethodException e) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflectMethod: " + String.valueOf(e));
        }
    }

    public static void writeConstructor(ObjectOutputStream out, Constructor<?> constructor) throws IOException {
        if (constructor == null) {
            out.writeObject(null);
        } else {
            ReflectionSerializer.writeClass(out, constructor.getDeclaringClass());
            ReflectionSerializer.writeClassArray(out, constructor.getParameterTypes());
        }
    }

    public static Constructor<?> readConstructor(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Class<?> clazz = ReflectionSerializer.readClass(in);
            if (clazz == null) {
                return null;
            }
            Class<?>[] params = ReflectionSerializer.readClassArray(in);
            return clazz.getConstructor(params);
        }
        catch (ClassCastException e) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Constructor: " + String.valueOf(e));
        }
        catch (NoSuchMethodException e) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.reflect.Constructor: " + String.valueOf(e));
        }
    }

    public static void writeClass(ObjectOutputStream out, Class<?> clazz) throws IOException {
        if (clazz == null) {
            out.writeObject(null);
        } else {
            out.writeObject(clazz.getName());
        }
    }

    public static Class<?> readClass(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            String name = (String)in.readObject();
            if (name == null) {
                return null;
            }
            if (name.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (name.equals("byte")) {
                return Byte.TYPE;
            }
            if (name.equals("char")) {
                return Character.TYPE;
            }
            if (name.equals("double")) {
                return Double.TYPE;
            }
            if (name.equals("float")) {
                return Float.TYPE;
            }
            if (name.equals("int")) {
                return Integer.TYPE;
            }
            if (name.equals("long")) {
                return Long.TYPE;
            }
            if (name.equals("short")) {
                return Short.TYPE;
            }
            if (name.equals("void")) {
                return Void.TYPE;
            }
            return ClassSource.classForName(name);
        }
        catch (ClassCastException e) {
            throw new StreamCorruptedException("(RRS) Could not read java.lang.Class: " + String.valueOf(e));
        }
    }

    public static void writeClassArray(ObjectOutputStream out, Class<?>[] classes) throws IOException {
        if (classes == null) {
            out.writeObject(null);
        } else {
            out.writeObject(classes.length);
            for (int i = 0; i < classes.length; ++i) {
                ReflectionSerializer.writeClass(out, classes[i]);
            }
        }
    }

    public static Class<?>[] readClassArray(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object readObject = in.readObject();
        if (readObject == null) {
            return null;
        }
        if (readObject instanceof Class[]) {
            return (Class[])readObject;
        }
        if (readObject instanceof Integer) {
            int count = (Integer)readObject;
            Class[] classes = new Class[count];
            for (int i = 0; i < count; ++i) {
                classes[i] = ReflectionSerializer.readClass(in);
            }
            return classes;
        }
        throw new StreamCorruptedException("(RRS) Could not read java.lang.Class[]: Found " + readObject.getClass().getName() + " instead.");
    }
}

