/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.PluginManager;
import java.net.URL;
import org.apache.log4j.Logger;

public class ModuleDelegationClassLoader
extends ClassLoader {
    public static final Logger LOGGER = Logger.getLogger(ModuleDelegationClassLoader.class);
    private final ClassLoader _applicationClassLoader;

    public ModuleDelegationClassLoader(ClassLoader applicationClassLoader) {
        super(applicationClassLoader);
        this._applicationClassLoader = applicationClassLoader;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this._applicationClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader moduleClassLoader = PluginManager.getInstance().getModuleClassLoaderForClass(name);
            if (moduleClassLoader != null) {
                try {
                    return moduleClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.debug((Object)("Found package, but couldn't find class " + name + " in loaded modules."));
                }
            }
            throw new ClassNotFoundException("ModuleDelegationClassLoader was unable to find class " + name);
        }
    }

    @Override
    public URL getResource(String name) {
        String cleanedName = name.startsWith("/") ? name.substring(1) : name;
        String searchString = cleanedName.substring(0, cleanedName.lastIndexOf(46)).replace('/', '.');
        ClassLoader moduleClassLoader = PluginManager.getInstance().getModuleClassLoaderForClass(searchString);
        if (moduleClassLoader != null) {
            return moduleClassLoader.getResource(cleanedName);
        }
        return super.getResource(name);
    }
}

