/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.jpms.impl;

import de.renew.plugin.jpms.ComponentLayer;
import de.renew.plugin.jpms.ComponentLayerFactory;
import de.renew.plugin.jpms.ExportsStrategy;
import de.renew.plugin.jpms.ModuleConfigurationException;
import de.renew.plugin.jpms.ModuleLayerListener;
import de.renew.plugin.jpms.ModuleLayerRemoveException;
import de.renew.plugin.jpms.impl.AIOPluginLayerFactory;
import de.renew.plugin.jpms.impl.LibraryLayer;
import de.renew.plugin.jpms.impl.LibraryLayerFactory;
import de.renew.plugin.jpms.impl.PluginLayerFactory;
import de.renew.plugin.jpms.impl.ResolveExportsStrategy;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ModuleManager {
    private static final Logger LOGGER = Logger.getLogger(ModuleManager.class);
    private final List<ComponentLayer> _loadedLayers = new ArrayList<ComponentLayer>();
    private final List<ComponentLayer> _removableLayers = new CopyOnWriteArrayList<ComponentLayer>();
    private final List<ModuleLayerListener> _layerListeners = new ArrayList<ModuleLayerListener>();
    private final ComponentLayerFactory _pluginLayerFactory;
    private final ComponentLayerFactory _libLayerFactory;
    private final ExportsStrategy _resolveStrategy;

    public ModuleManager() {
        this(new ResolveExportsStrategy());
    }

    public ModuleManager(ExportsStrategy strategy) {
        this._loadedLayers.add(ComponentLayer.BOOT);
        this._pluginLayerFactory = new PluginLayerFactory();
        this._libLayerFactory = new LibraryLayerFactory();
        this._resolveStrategy = strategy;
        this._resolveStrategy.putUnresolvedExportsFromBoot();
    }

    public void createPluginLayer(String pluginName, Path moduleJarPath, ClassLoader parentCL) {
        this.createPluginLayer(pluginName, Set.of(moduleJarPath), parentCL);
    }

    public void createPluginLayer(String pluginName, Set<Path> moduleJarPaths, ClassLoader parentCL) {
        Objects.requireNonNull(parentCL);
        ModuleManager.checkSameOrigin(moduleJarPaths);
        ComponentLayer component = this.resolveComponentLayer(pluginName, moduleJarPaths, parentCL);
        ModuleLayer layer = component.getLayer();
        this._removableLayers.removeAll(component.parents());
        for (Module m : layer.modules()) {
            this._resolveStrategy.tryResolveExportsTo(m);
            this._resolveStrategy.putUnresolvedExportsFrom(m, component.getController());
        }
        this.layerAdded(layer);
        this._loadedLayers.add(component);
        this._removableLayers.add(component);
    }

    private ComponentLayer resolveComponentLayer(String name, Set<Path> moduleJarPaths, ClassLoader parentCL) {
        if (name.equals("Renew Cloud Native Spring")) {
            Path moduleJarPath = (Path)moduleJarPaths.stream().findFirst().orElseThrow();
            Set<Path> libraryLocations = ModuleManager.getLibraryLocations(moduleJarPath);
            return new AIOPluginLayerFactory().create(name, moduleJarPaths, libraryLocations, this._loadedLayers, parentCL).orElseThrow();
        }
        Set<ModuleReference> modulesToLoad = moduleJarPaths.stream().map(ModuleManager::getModuleReferenceFromPath).collect(Collectors.toUnmodifiableSet());
        Set<ModuleDescriptor.Requires> requiredModules = ModuleManager.getAllDependencies(modulesToLoad);
        List<String> libraryNames = ModuleManager.getRequiredLibraryNames(requiredModules);
        this.updateLibraries(libraryNames);
        Path moduleJarPath = (Path)moduleJarPaths.stream().findFirst().orElseThrow();
        this.checkCreationOfMoreLibraryLayer(moduleJarPath, libraryNames, parentCL);
        return this._pluginLayerFactory.create(name, moduleJarPaths, null, this._loadedLayers, parentCL).orElseThrow();
    }

    private void updateLibraries(List<String> libraryNames) {
        if (libraryNames.isEmpty()) {
            return;
        }
        ArrayList previouslyLoadedLibraries = new ArrayList();
        for (String libraryName : libraryNames) {
            this._loadedLayers.stream().map(ModuleManager::getModuleNamesInLayer).filter(l -> l.contains(libraryName)).forEach(l -> previouslyLoadedLibraries.add(libraryName));
        }
        libraryNames.removeAll(previouslyLoadedLibraries);
    }

    private void createLibraryLayer(Path modulePath, String libraryName, ClassLoader parentClassLoader) {
        Path pluginPath = modulePath;
        if (modulePath.resolveSibling("plugin.cfg").toFile().exists()) {
            pluginPath = modulePath.getParent();
        }
        Set<Path> libraryLocations = ModuleManager.getLibraryLocations(pluginPath);
        ModuleFinder moduleFinder = ModuleFinder.of((Path[])libraryLocations.toArray(Path[]::new));
        Set<ModuleReference> foundModules = moduleFinder.findAll();
        ModuleReference libraryModule = foundModules.stream().filter(m -> m.descriptor().name().equals(libraryName)).findFirst().orElseThrow();
        Set<ModuleDescriptor.Requires> requiredModules = libraryModule.descriptor().requires();
        List<String> libraryNames = ModuleManager.getRequiredLibraryNames(requiredModules);
        this.updateLibraries(libraryNames);
        this.checkCreationOfMoreLibraryLayer(modulePath, libraryNames, parentClassLoader);
        ComponentLayer layer = this._libLayerFactory.create(null, Set.of(Path.of(libraryModule.location().orElseThrow())), libraryLocations, this._loadedLayers, parentClassLoader).orElseThrow();
        this._removableLayers.removeAll(layer.parents());
        this._loadedLayers.add(layer);
        this._removableLayers.add(layer);
    }

    private void checkCreationOfMoreLibraryLayer(Path moduleJarPath, List<String> libraryNames, ClassLoader parentCL) {
        if (libraryNames.isEmpty()) {
            return;
        }
        for (String lib : libraryNames) {
            boolean createLibLayer = this._loadedLayers.stream().map(ModuleManager::getModuleNamesInLayer).noneMatch(m -> m.contains(lib));
            if (!createLibLayer) continue;
            this.createLibraryLayer(moduleJarPath, lib, parentCL);
        }
    }

    private static void checkSameOrigin(Set<Path> dirs) {
        boolean hasSameParent;
        if (dirs.size() < 2) {
            return;
        }
        boolean bl = hasSameParent = dirs.stream().map(Path::getParent).distinct().limit(2L).count() == 1L;
        if (!hasSameParent) {
            throw new ModuleConfigurationException("All jars need to have the same origin. While trying to load from " + String.valueOf(dirs) + " at least one jar was located in a different directory.");
        }
    }

    private static Set<Path> getLibraryLocations(Path modulePath) {
        Path pluginLibDir = Path.of(modulePath.toString().replace("plugins", "libs").replaceFirst("\\.jar$", ""), new String[0]);
        HashSet<Path> libraryLocations = new HashSet<Path>();
        if (!pluginLibDir.toFile().isDirectory()) {
            libraryLocations.add(pluginLibDir.getParent());
            return libraryLocations;
        }
        libraryLocations.add(pluginLibDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginLibDir, "*.txt");){
            for (Path path : stream) {
                libraryLocations.add(pluginLibDir.resolve(String.join((CharSequence)"", Files.readAllLines(path))));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Cannot open " + String.valueOf(libraryLocations) + " to search for text files referencing jars."));
        }
        return libraryLocations;
    }

    private static ModuleReference getModuleReferenceFromPath(Path moduleJarPath) {
        Set<ModuleReference> referencedModulesInJar = ModuleFinder.of(moduleJarPath).findAll();
        if (referencedModulesInJar.size() != 1) {
            throw new ModuleConfigurationException("A modular jar must contain exactly one module!");
        }
        return (ModuleReference)referencedModulesInJar.stream().findFirst().get();
    }

    private static Set<ModuleDescriptor.Requires> getAllDependencies(Set<ModuleReference> modulesToLoad) {
        return modulesToLoad.stream().map(ModuleReference::descriptor).map(ModuleDescriptor::requires).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    private static List<String> getRequiredLibraryNames(Set<ModuleDescriptor.Requires> requires) {
        ArrayList<String> libraryNames = new ArrayList<String>();
        for (ModuleDescriptor.Requires require : requires) {
            String requireString = require.name();
            boolean isStatic = require.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC);
            if (isStatic || requireString.startsWith("java.") && !requireString.equals("java.mail") || requireString.startsWith("jdk.") || ModuleManager.isRenewModule(requireString)) continue;
            libraryNames.add(requireString);
        }
        return libraryNames;
    }

    public void removeLayerOfPlugin(String name) throws ModuleLayerRemoveException {
        Set layersOfPlugin = this._loadedLayers.stream().filter(l -> l.getName().equals(name)).collect(Collectors.toSet());
        if (layersOfPlugin.size() != 1) {
            throw new ModuleConfigurationException("Plugin " + name + " must have exactly one layer!");
        }
        ComponentLayer toRemove = (ComponentLayer)layersOfPlugin.stream().findFirst().get();
        if (!this._removableLayers.contains(toRemove)) {
            this.throwRemoveException(toRemove);
        }
        this.layerRemoved(toRemove.getLayer());
        this.removeLayer(toRemove);
        this.removeUnnecessaryLibraryLayers();
    }

    private void removeUnnecessaryLibraryLayers() {
        for (ComponentLayer removableLayer : this._removableLayers) {
            if (!(removableLayer instanceof LibraryLayer)) continue;
            this.removeLayer(removableLayer);
        }
    }

    private void removeLayer(ComponentLayer layerToRemove) {
        this._loadedLayers.remove(layerToRemove);
        this._removableLayers.remove(layerToRemove);
        this.updateRemovableLayers();
    }

    private void throwRemoveException(ComponentLayer toRemove) {
        String layerName = toRemove.getName();
        ArrayList<String> childrenList = new ArrayList<String>();
        for (ComponentLayer l : this._loadedLayers) {
            if (!l.parents().contains(toRemove)) continue;
            childrenList.add(l.getLayer().toString());
        }
        throw new ModuleLayerRemoveException(layerName, childrenList);
    }

    private void updateRemovableLayers() {
        ArrayList<ModuleLayer> allParents = new ArrayList<ModuleLayer>();
        for (ComponentLayer layer : this._loadedLayers) {
            allParents.addAll(layer.getLayer().parents());
        }
        for (ComponentLayer layer : this._loadedLayers) {
            if (this._removableLayers.contains(layer) || allParents.contains(layer.getLayer())) continue;
            this._removableLayers.add(layer);
        }
    }

    private static List<String> getModuleNamesInLayer(ComponentLayer layer) {
        return layer.getLayer().modules().stream().map(Module::getName).collect(Collectors.toList());
    }

    public ClassLoader getModuleClassLoaderForClass(String className) {
        if (!this.getClass().getModule().isNamed()) {
            return this.getClass().getClassLoader();
        }
        String noStartingSlash = className.startsWith("/") ? className.substring(1) : className;
        String normalizedClassName = noStartingSlash.replace('/', '.');
        int packageEndIndex = normalizedClassName.lastIndexOf(46);
        if (packageEndIndex == -1) {
            LOGGER.debug((Object)("The class " + className + "is not fully qualified. Can be ignored if the call originated from an InscriptionParser."));
            return null;
        }
        String packageName = normalizedClassName.substring(0, packageEndIndex);
        for (ComponentLayer layer : this._loadedLayers) {
            for (Module module : layer.getLayer().modules()) {
                if (!module.getPackages().contains(packageName)) continue;
                return module.getClassLoader();
            }
        }
        return null;
    }

    private void layerAdded(ModuleLayer layer) {
        for (ModuleLayerListener l : this._layerListeners) {
            l.layerAdded(layer.modules());
        }
    }

    private void layerRemoved(ModuleLayer layer) {
        for (ModuleLayerListener l : this._layerListeners) {
            l.layerRemoved(layer.modules());
        }
    }

    public void registerLayerListener(ModuleLayerListener l) {
        this._layerListeners.add(l);
    }

    private static boolean isRenewModule(String name) {
        return name.startsWith("de.renew.") || name.equals("CH.ifa.draw") || name.startsWith("net.paose.");
    }
}

