/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.jpms.impl;

import de.renew.plugin.jpms.ExportsStrategy;
import de.renew.plugin.jpms.impl.UnresolvedExports;
import java.lang.module.ModuleDescriptor;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ResolveExportsStrategy
implements ExportsStrategy {
    private final Map<String, Set<UnresolvedExports>> _modulesUnresolvedExports = new HashMap<String, Set<UnresolvedExports>>();

    @Override
    public void putUnresolvedExportsFromBoot() {
        Module loader = this.getClass().getModule();
        if (!loader.isNamed()) {
            return;
        }
        ResolveExportsStrategy.getQualifiedExportsByTarget(loader).forEach((k, v) -> {
            this._modulesUnresolvedExports.putIfAbsent((String)k, new HashSet());
            this._modulesUnresolvedExports.get(k).add(UnresolvedExports.withTarget(k).fromBoot().addPackages((Set<String>)v));
        });
    }

    @Override
    public void putUnresolvedExportsFrom(Module m, ModuleLayer.Controller c) {
        ResolveExportsStrategy.getQualifiedExportsByTarget(m).forEach((k, v) -> {
            this._modulesUnresolvedExports.putIfAbsent((String)k, new HashSet());
            Set<UnresolvedExports> target = this._modulesUnresolvedExports.get(k);
            UnresolvedExports moduleExports = UnresolvedExports.withTarget(k).from(c).addPackages((Set<String>)v);
            if (!target.add(moduleExports)) {
                target.stream().filter(moduleExports::equals).findFirst().ifPresent(e -> e.from(c).addPackages((Set<String>)v));
            }
        });
    }

    @Override
    public void tryResolveExportsTo(Module m) {
        this._modulesUnresolvedExports.computeIfPresent(m.getName(), (k, v) -> {
            v.forEach(e -> e.resolve(m));
            return v;
        });
    }

    private static Map<String, Set<String>> getQualifiedExportsByTarget(Module m) {
        return m.getDescriptor().exports().stream().filter(ModuleDescriptor.Exports::isQualified).flatMap(pkg -> pkg.targets().stream().map(s -> new AbstractMap.SimpleEntry<String, String>((String)s, pkg.source()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
    }
}

