/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.DependencyCheckList;
import de.renew.plugin.DependencyNotFulfilledException;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.jpms.impl.ModuleManager;
import de.renew.plugin.load.AbstractPluginLoader;
import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.plugin.load.PluginLoader;
import de.renew.plugin.locate.PluginLocationFinders;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class PluginLoaderComposition
implements PluginLoader {
    private static final Logger LOGGER = Logger.getLogger(PluginLoaderComposition.class);
    private final Collection<PluginLoader> _loaders = new Vector<PluginLoader>();
    private static ISplashscreenPlugin _splashscreen = null;
    private final ModuleManager _moduleManager;

    public PluginLoaderComposition(ModuleManager moduleManager) {
        this._moduleManager = moduleManager;
    }

    public static void setSplashScreen(ISplashscreenPlugin splashscreen) {
        _splashscreen = splashscreen;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<IPlugin> loadPlugins() {
        LOGGER.info((Object)"loading plugins...");
        DependencyCheckList<PluginProperties> dependencyList = new DependencyCheckList<PluginProperties>();
        Collection<PluginProperties> locations = PluginLocationFinders.getInstance().findPluginLocations();
        Vector<IPlugin> result = new Vector<IPlugin>();
        PluginProperties splashscreenProps = null;
        Vector<String> loadedPluginMainClasses = new Vector<String>();
        for (PluginProperties pluginProperties : locations) {
            if (pluginProperties.getName().equals("Renew Suite") && pluginProperties.getBoolProperty("de.renew.suite.showAtStart")) {
                this.loadPluginFromURL(pluginProperties.getURL());
                if (PluginProperties.getUserProperties().getBoolProperty("de.renew.suite.loadedSuite")) {
                    return result;
                }
                dependencyList.addElement(DependencyCheckList.DependencyElement.create(pluginProperties));
                continue;
            }
            if (pluginProperties.getName().equals("Renew Splashscreen")) {
                splashscreenProps = pluginProperties;
                continue;
            }
            dependencyList.addElement(DependencyCheckList.DependencyElement.create(pluginProperties));
        }
        List fulfilledDependencies = dependencyList.getFulfilledObjects();
        for (PluginProperties plugin : fulfilledDependencies) {
            LOGGER.debug((Object)plugin);
        }
        boolean bl = false;
        int start = splashscreenProps != null ? -1 : 0;
        for (int i = start; i < fulfilledDependencies.size(); ++i) {
            if (_splashscreen != null) {
                void var7_10;
                void old = var7_10++;
                double count = i + 1;
                double d = fulfilledDependencies.size();
                int newValue = (int)(count / d * 100.0);
                try {
                    _splashscreen.propertyChange(new PropertyChangeEvent(this, "progress", (int)old, newValue));
                }
                catch (Exception e) {
                    _splashscreen = null;
                }
            }
            PluginProperties props = i == -1 ? splashscreenProps : (PluginProperties)fulfilledDependencies.get(i);
            if (PluginManager.getInstance().getPluginByName(props.getName()) != null) {
                LOGGER.debug((Object)("PluginLoader: A plugin with the name " + props.getName() + " has already been loaded. Skipping " + String.valueOf(props.getURL())));
                continue;
            }
            boolean isModularPlugin = this.resolvePluginJars(props);
            IPlugin loaded = this.loadPlugin(props);
            if (loaded != null) {
                try {
                    Collection<String> collection;
                    PluginManager.getInstance().addPlugin(loaded, isModularPlugin);
                    if (_splashscreen != null) {
                        try {
                            _splashscreen.propertyChange(new PropertyChangeEvent(this, "pluginLoaded", null, loaded.getName()));
                        }
                        catch (Exception exception) {
                            _splashscreen = null;
                        }
                    }
                    if (!new HashSet<String>(loadedPluginMainClasses).containsAll(collection = loaded.getProperties().getProvisions())) {
                        loadedPluginMainClasses.addAll(collection);
                    }
                    result.add(loaded);
                    continue;
                }
                catch (DependencyNotFulfilledException dependencyNotFulfilledException) {
                    assert (false) : "The PluginManager doubts our dependency check for " + String.valueOf(loaded);
                    continue;
                }
            }
            LOGGER.debug((Object)("PluginLoaderComposition: did not load plugin from " + String.valueOf(props)));
            Collection<DependencyCheckList.DependencyElement<PluginProperties>> collection = dependencyList.removeElementWithDependencies(props);
            if (!collection.isEmpty()) {
                LOGGER.debug((Object)"PluginLoaderComposition: recalculated dependencies.");
            }
            fulfilledDependencies = dependencyList.getFulfilledObjects();
            --i;
        }
        Collection unfulfilled = dependencyList.getUnfulfilled();
        if (!unfulfilled.isEmpty()) {
            LOGGER.warn((Object)"\nThere are plugins with unfulfilled dependencies:");
            Vector<String> provisions = new Vector<String>();
            HashMap missing = new HashMap();
            for (DependencyCheckList.DependencyElement dependencyElement : unfulfilled) {
                LOGGER.warn((Object)("Plugin with unfulfilled dependencies: " + dependencyElement.toStringExtended(loadedPluginMainClasses) + "\n"));
                for (String provisionsByDE : dependencyElement.getProvisions()) {
                    if (provisions.contains(provisionsByDE)) continue;
                    provisions.add(provisionsByDE);
                }
                for (String required : dependencyElement.getMissingRequirements(loadedPluginMainClasses)) {
                    String pluginName;
                    if (provisions.contains(required)) continue;
                    List<String> requiredBy = new Vector();
                    if (missing.containsKey(required)) {
                        requiredBy = (List)missing.get(required);
                    }
                    if (!requiredBy.contains(pluginName = dependencyElement.getPluginName())) {
                        requiredBy.add(pluginName);
                    }
                    missing.put(required, requiredBy);
                }
                for (String provisionsByDE : dependencyElement.getProvisions()) {
                    missing.remove(provisionsByDE);
                }
            }
            Vector<CallSite> erroneousPlugins = new Vector<CallSite>();
            for (String missingPlugin : missing.keySet()) {
                erroneousPlugins.add((CallSite)((Object)(missingPlugin + " [Required by: " + CollectionLister.toString((Collection)missing.get(missingPlugin), ", ") + "]")));
            }
            LOGGER.error((Object)("\nPLEASE add the plugin(s) with the following provisions in their plugin.cfg\n\n* " + CollectionLister.toString(erroneousPlugins, "\n* ") + "\n"));
        }
        if (_splashscreen != null) {
            _splashscreen.closeSplashScreen();
        }
        return result;
    }

    private boolean resolvePluginJars(PluginProperties props) {
        URL[] urlsToPluginJars = AbstractPluginLoader.unifyURL(props.getURL());
        Path[] pluginJars = new Path[urlsToPluginJars.length];
        boolean isModularPlugin = true;
        int c = 0;
        for (URL url : urlsToPluginJars) {
            try {
                pluginJars[c++] = Path.of(url.toURI());
                isModularPlugin &= this.isModularJar(pluginJars[c - 1].toFile());
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)("Could not create plugin file of " + props.getName() + " due to syntax exception."), (Throwable)e);
                return false;
            }
        }
        if (isModularPlugin) {
            Supplier<Boolean> isPluginFolder = () -> props.getURL().getPath().toLowerCase(Locale.ROOT).endsWith("plugin.cfg");
            if (pluginJars.length == 1 && !isPluginFolder.get().booleanValue()) {
                this._moduleManager.createPluginLayer(props.getName(), pluginJars[0], ClassLoader.getSystemClassLoader());
            } else {
                this._moduleManager.createPluginLayer(props.getName(), Set.of(pluginJars), ClassLoader.getSystemClassLoader());
            }
            return true;
        }
        this.addPluginJarsToClassLoader(urlsToPluginJars);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("PluginLoaderComposition: Adding files of plugin " + props.getName() + " to plugin class loader. At least one jar was found to be non-modular."));
        }
        return false;
    }

    private void addPluginJarsToClassLoader(URL[] urlsToPluginJars) {
        PluginClassLoader pluginCL = PluginManager.getInstance().getPluginClassLoader();
        for (URL url : urlsToPluginJars) {
            pluginCL.addURL(url);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModularJar(File jarfile) {
        try (JarFile jarToCheck = new JarFile(jarfile);){
            if (jarToCheck.getEntry("module-info.class") == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Error while checking Jar file  " + String.valueOf(jarfile.toPath()) + " " + e.getMessage()));
        }
        return false;
    }

    public void addLoader(PluginLoader l) {
        this._loaders.add(l);
    }

    public void removeLoader(PluginLoader l) {
        this._loaders.remove(l);
    }

    @Override
    public IPlugin loadPlugin(PluginProperties props) {
        for (PluginLoader loader : this._loaders) {
            try {
                IPlugin result = loader.loadPlugin(props);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                LOGGER.error((Object)("PluginLoaderComposition: " + String.valueOf(e) + " occurred when " + String.valueOf(loader) + " tried to load plugin from " + String.valueOf(props.getURL())));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        LOGGER.error((Object)("No loader was able to load " + props.getName() + "!"));
        return null;
    }

    @Override
    public IPlugin loadPluginFromURL(URL source) {
        IPlugin result = null;
        PluginManager mgr = PluginManager.getInstance();
        PluginLocationFinders pluginLocationFinder = PluginLocationFinders.getInstance();
        PluginProperties props = pluginLocationFinder.checkPluginLocation(source);
        boolean isModularPlugin = false;
        if (props != null) {
            if (!mgr.checkDependenciesFulfilled(props)) {
                List<String> missingDependencies = mgr.getMissingDependencies(props);
                for (String missingDependency : missingDependencies) {
                    if (!mgr.getPluginsProviding(missingDependency).isEmpty()) continue;
                    PluginProperties pluginProperties = pluginLocationFinder.findPluginByProvides(missingDependency);
                    if (pluginProperties != null) {
                        this.loadPluginFromURL(pluginProperties.getURL());
                        continue;
                    }
                    LOGGER.error((Object)("Could not find the Plugin which provides " + missingDependency + "; another Plugin depends on it"));
                }
            }
            if (mgr.checkDependenciesFulfilled(props)) {
                isModularPlugin = this.resolvePluginJars(props);
                result = this.loadPlugin(props);
                LOGGER.info((Object)("loaded plugin: " + result.getName()));
            } else {
                LOGGER.error((Object)("Dependencies are not fulfilled for plugin \n\t" + props.getName() + "\nlocated at \n\t" + String.valueOf(props.getURL())));
            }
        } else {
            for (PluginLoader loader : this._loaders) {
                try {
                    result = loader.loadPluginFromURL(source);
                    if (result == null) continue;
                    break;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("PluginLoaderComposition: " + String.valueOf(e) + " occurred when " + String.valueOf(loader) + " tried to load plugin from " + String.valueOf(source)));
                    LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (result != null) {
            try {
                mgr.addPlugin(result, isModularPlugin);
                result.startUpComplete(false);
            }
            catch (DependencyNotFulfilledException e) {
                LOGGER.error((Object)("Dependencies are not fulfilled for " + String.valueOf(result) + " loaded from " + String.valueOf(source)));
                return null;
            }
        }
        return result;
    }
}

