/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.di.ServiceContainer;
import de.renew.plugin.load.AbstractPluginLoader;
import de.renew.plugin.load.PluginInstantiationException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;

public class SimplePluginLoader
extends AbstractPluginLoader {
    public SimplePluginLoader(PluginClassLoader loader, ServiceContainer container) {
        super(loader, container);
    }

    @Override
    protected IPlugin createPlugin(PluginProperties props, Class<? extends IPlugin> mainClass) throws PluginInstantiationException {
        try {
            Class[] params = new Class[]{props.getClass()};
            Constructor<? extends IPlugin> cons = mainClass.getConstructor(params);
            Object[] args = new Object[]{props};
            return cons.newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            throw new PluginInstantiationException(props.getName(), e);
        }
    }

    public static class PluginConfigFinder {
        public static InputStream getConfigInputStream(URL pluginLocation) throws MalformedURLException, IOException {
            URL configLocation = new URL(pluginLocation, "plugin.cfg");
            InputStream stream = null;
            try {
                stream = configLocation.openStream();
            }
            catch (Exception e) {
                Object urlString = pluginLocation.toExternalForm();
                int index = ((String)urlString).lastIndexOf(33);
                if (index > -1) {
                    urlString = ((String)urlString).substring(0, index) + "/plugin.cfg";
                    AbstractPluginLoader.LOGGER.debug((Object)("trying alternate URL for plugin.cfg: " + (String)urlString));
                }
                configLocation = new URL((String)urlString);
                stream = configLocation.openStream();
            }
            return stream;
        }
    }
}

