/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.locate.PluginLocationFinder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class PluginLocationFinders
implements PluginLocationFinder {
    private static PluginLocationFinders _instance;
    private Collection<PluginLocationFinder> _finders = new Vector<PluginLocationFinder>();

    private PluginLocationFinders() {
    }

    public static PluginLocationFinders getInstance() {
        if (_instance == null) {
            _instance = new PluginLocationFinders();
        }
        return _instance;
    }

    public void addLocationFinder(PluginLocationFinder f) {
        this._finders.add(f);
    }

    public void removeLocationFinder(PluginLocationFinder f) {
        this._finders.remove(f);
    }

    @Override
    public Collection<PluginProperties> findPluginLocations() {
        Vector<PluginProperties> result = new Vector<PluginProperties>();
        for (PluginLocationFinder finder : this._finders) {
            Collection<PluginProperties> locations = finder.findPluginLocations();
            result.addAll(locations);
        }
        PluginProperties userProperties = PluginProperties.getUserProperties();
        if (userProperties.getBoolProperty("de.renew.plugin.autoLoad", true)) {
            Collection<String> noLoad = PropertyHelper.parseListString(userProperties.getProperty("de.renew.plugin.noLoad", ""));
            cleanedList = result.iterator();
            while (cleanedList.hasNext()) {
                PluginProperties props = (PluginProperties)cleanedList.next();
                if (!noLoad.contains(props.getName())) continue;
                cleanedList.remove();
            }
        } else {
            Collection<String> load = PropertyHelper.parseListString(userProperties.getProperty("de.renew.plugin.load", ""));
            cleanedList = result.iterator();
            while (cleanedList.hasNext()) {
                PluginProperties props = (PluginProperties)cleanedList.next();
                if (load.contains(props.getName())) continue;
                cleanedList.remove();
            }
        }
        return result;
    }

    @Override
    public PluginProperties checkPluginLocation(URL url) {
        PluginProperties props = null;
        for (PluginLocationFinder finder : this._finders) {
            if (props != null) continue;
            props = finder.checkPluginLocation(url);
        }
        return props;
    }

    @Override
    public PluginProperties findPluginByProvides(String provides) {
        PluginProperties props = null;
        for (PluginLocationFinder finder : this._finders) {
            if (props != null) continue;
            props = finder.findPluginByProvides(provides);
        }
        return props;
    }

    @Override
    public PluginProperties findPluginByName(String pluginName) {
        PluginProperties props = null;
        for (PluginLocationFinder finder : this._finders) {
            if (props != null) continue;
            props = finder.findPluginByName(pluginName);
        }
        return props;
    }

    @Override
    public Collection<URL> getLocations() {
        ArrayList<URL> locations = new ArrayList<URL>();
        for (PluginLocationFinder finder : this._finders) {
            if (locations.containsAll(finder.getLocations())) continue;
            locations.addAll(finder.getLocations());
        }
        return locations;
    }
}

