/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AbstractTabLayoutManagerPane;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayout;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutPossibility;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.MenuLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuLineLayoutPane
extends AbstractTabLayoutManagerPane {
    private MenuLayoutBlock menu;
    private LayoutBlock info;
    private TabsLayoutBlock tabs;
    private MenuLineLayout layout;

    public MenuLineLayoutPane(MenuLineLayout layout, TabPane pane) {
        super(pane);
        this.layout = layout;
        this.menu = layout.getFactory().createMenu(layout, pane);
        this.info = layout.getFactory().createInfo(layout, pane);
        this.tabs = layout.getFactory().createTabs(layout, pane);
    }

    public TabsLayoutBlock getTabs() {
        return this.tabs;
    }

    public LayoutBlock getInfo() {
        return this.info;
    }

    public MenuLayoutBlock getMenu() {
        return this.menu;
    }

    public Dimension getPreferredSize() {
        List<MenuLineLayoutPossibility> layouts = this.listLayouts();
        Dimension bestSize = new Dimension(0, 0);
        Dimension dockableSize = new Dimension();
        TabPane pane = this.getPane();
        for (Dockable dockable : pane.getDockables()) {
            Dimension size = pane.getPreferredSize(dockable);
            dockableSize.width = Math.max(dockableSize.width, size.width);
            dockableSize.height = Math.max(dockableSize.height, size.height);
        }
        if (this.getPane().getDockTabPlacement().isHorizontal()) {
            for (MenuLineLayoutPossibility layout : layouts) {
                if (!layout.isPreferred()) continue;
                Dimension size = layout.getSize();
                if (size.width <= bestSize.width) continue;
                bestSize = size;
            }
            bestSize.width = Math.max(bestSize.width, dockableSize.width);
            bestSize.height += dockableSize.height;
        } else {
            for (MenuLineLayoutPossibility layout : layouts) {
                if (!layout.isPreferred()) continue;
                Dimension size = layout.getSize();
                if (size.height <= bestSize.height) continue;
                bestSize = size;
            }
            bestSize.width += dockableSize.width;
            bestSize.height = Math.max(bestSize.height, dockableSize.height);
        }
        return bestSize;
    }

    public Dimension getMinimumSize() {
        List<MenuLineLayoutPossibility> layouts = this.listLayouts();
        Dimension bestSize = null;
        Dimension dockableSize = new Dimension();
        TabPane pane = this.getPane();
        for (Dockable dockable : pane.getDockables()) {
            Dimension size = pane.getMinimumSize(dockable);
            dockableSize.width = Math.max(dockableSize.width, size.width);
            dockableSize.height = Math.max(dockableSize.height, size.height);
        }
        if (this.getPane().getDockTabPlacement().isHorizontal()) {
            for (MenuLineLayoutPossibility layout : layouts) {
                Dimension size = layout.getSize();
                if (bestSize != null && size.width >= bestSize.width) continue;
                bestSize = size;
            }
            bestSize.width = this.isUseSmallMinimumSize() ? dockableSize.width : Math.max(bestSize.width, dockableSize.width);
            bestSize.height += dockableSize.height;
        } else {
            for (MenuLineLayoutPossibility layout : layouts) {
                Dimension size = layout.getSize();
                if (bestSize != null && size.height >= bestSize.height) continue;
                bestSize = size;
            }
            bestSize.width += dockableSize.width;
            bestSize.height = this.isUseSmallMinimumSize() ? dockableSize.height : Math.max(bestSize.height, dockableSize.height);
        }
        return bestSize;
    }

    public void destroy() {
        this.getPane().destroyMenu(this.menu.getMenu());
    }

    public MenuLineLayout getLayout() {
        return this.layout;
    }

    public int getIndexOfTabAt(Point mouseLocation) {
        return this.tabs.getIndexOfTabAt(mouseLocation);
    }

    public void layout() {
        AxisConversion conversion = this.getLayout().getConversion(this.getPane());
        List<MenuLineLayoutPossibility> layouts = this.listLayouts();
        Rectangle available = conversion.viewToModel(this.getPane().getAvailableArea());
        int space = available.width;
        MenuLineLayoutPossibility best = null;
        int bestSize = -1;
        double bestScore = 0.0;
        MenuLineLayoutPossibility smallest = null;
        int smallestSize = -1;
        for (MenuLineLayoutPossibility layout : layouts) {
            Dimension size = conversion.viewToModel(layout.getSize());
            if (size.width <= space) {
                double score = layout.getScore();
                if (best == null || bestScore == score && bestSize < size.width || bestScore < score) {
                    bestScore = score;
                    best = layout;
                }
            }
            if (smallest != null && size.width >= smallestSize) continue;
            smallest = layout;
            smallestSize = size.width;
        }
        if (best != null) {
            best.apply();
        } else if (smallest != null) {
            smallest.apply();
        }
    }

    private List<MenuLineLayoutPossibility> listLayouts() {
        ArrayList<MenuLineLayoutPossibility> results = new ArrayList<MenuLineLayoutPossibility>();
        TabPlacement orientation = this.getPane().getDockTabPlacement();
        this.tabs.setOrientation(orientation);
        Size[] sizesTabs = this.tabs.getSizes();
        this.menu.setOrientation(orientation);
        Size[] sizesMenu = this.menu.getSizes();
        if (this.info != null) {
            Size[] sizesInfo;
            this.info.setOrientation(orientation);
            for (Size size : sizesInfo = this.info.getSizes()) {
                this.listLayouts(results, size, sizesMenu, sizesTabs);
            }
        } else {
            this.listLayouts(results, null, sizesMenu, sizesTabs);
        }
        return results;
    }

    private void listLayouts(List<MenuLineLayoutPossibility> list, Size infoSize, Size[] menuSizes, Size[] tabSizes) {
        for (Size tab : tabSizes) {
            if (this.tabs.isAllTabs(tab)) {
                this.listLayouts(list, infoSize, (Size)null, tab);
                continue;
            }
            for (Size menu : menuSizes) {
                this.listLayouts(list, infoSize, menu, tab);
            }
        }
    }

    private void listLayouts(List<MenuLineLayoutPossibility> list, Size infoSize, Size menuSize, Size tabSize) {
        boolean infoMustBeMinimum;
        boolean tabMustBeMinimum = infoSize != null && infoSize.isMinimum() || menuSize != null;
        boolean tabMustBeSingle = menuSize != null && menuSize.isMinimum();
        boolean bl = infoMustBeMinimum = menuSize != null && menuSize.isMinimum();
        if (tabMustBeMinimum && !tabSize.isMinimum()) {
            return;
        }
        if (tabMustBeSingle && this.tabs.getTabsCount(tabSize) > 1) {
            return;
        }
        if (infoMustBeMinimum && infoSize != null && !infoSize.isMinimum()) {
            return;
        }
        list.add(this.getLayout(tabSize, menuSize, infoSize));
    }

    protected MenuLineLayoutPossibility getLayout(Size tabSize, Size menuSize, Size infoSize) {
        return new MenuLineLayoutPossibility(this, tabSize, menuSize, infoSize);
    }

    @Override
    public void infoComponentChanged(TabPane pane, LonelyTabPaneComponent oldInfo, LonelyTabPaneComponent newInfo) {
        super.infoComponentChanged(pane, oldInfo, newInfo);
        this.info = newInfo == null ? null : newInfo.toLayoutBlock();
    }
}

