/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderMetaMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlaceholderList<D, S, P extends PlaceholderListItem<D>> {
    public static final Path PLACEHOLDER_MAP_FORMAT = new Path("dock.PlaceholderList");
    private PlaceholderStrategy strategy;
    private Entry head = null;
    private Entry headPlaceholder = null;
    private Entry headDockable = null;
    private SubList<Item> allItems = new SubList<Item>(Level.BASE){

        @Override
        protected Item wrap(Item item) {
            return item;
        }

        @Override
        protected boolean visible(Item item) {
            return true;
        }

        @Override
        protected Item unwrap(Item item) {
            return item;
        }
    };
    private SubList<Set<Path>> allPlaceholders = new SubList<Set<Path>>(Level.BASE){

        @Override
        protected Item wrap(Set<Path> object) {
            return new Item(PlaceholderList.this, object);
        }

        @Override
        protected boolean visible(Item item) {
            return true;
        }

        @Override
        protected Set<Path> unwrap(Item item) {
            Set<Path> result = item.getPlaceholderSet();
            if (result == null) {
                return Collections.emptySet();
            }
            return result;
        }
    };
    private SubList<Set<Path>> purePlaceholders = new SubList<Set<Path>>(Level.PLACEHOLDER){

        @Override
        protected Item wrap(Set<Path> object) {
            return new Item(PlaceholderList.this, object);
        }

        @Override
        protected boolean visible(Item item) {
            return item.isPlaceholder();
        }

        @Override
        protected Set<Path> unwrap(Item item) {
            return item.getPlaceholderSet();
        }
    };
    private SubList<P> dockables = new SubList<P>(Level.DOCKABLE){

        @Override
        protected Item wrap(P object) {
            return new Item(PlaceholderList.this, object);
        }

        @Override
        protected boolean visible(Item item) {
            return !item.isPlaceholder();
        }

        @Override
        protected P unwrap(Item item) {
            return item.getDockable();
        }

        @Override
        public void add(int index, P object) {
            super.add(index, object);
            this.removeDockable(object.asDockable());
        }

        private void removeDockable(D dockable) {
            Object station;
            Path placeholder = PlaceholderList.this.getPlaceholder(dockable);
            if (placeholder != null) {
                PlaceholderList.this.removeAll(placeholder);
            }
            if ((station = PlaceholderList.this.toStation(dockable)) != null) {
                for (Object child : PlaceholderList.this.getChildren(station)) {
                    this.removeDockable(child);
                }
            }
        }
    };
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> placeholders) {
            PlaceholderList.this.removeAll(placeholders);
        }
    };
    private boolean bound = false;

    public PlaceholderList() {
    }

    public PlaceholderList(PlaceholderMap map, PlaceholderListItemConverter<D, P> converter) {
        this.read(map, converter);
    }

    protected abstract Path getPlaceholder(D var1);

    protected abstract String toString(D var1);

    protected abstract S toStation(D var1);

    protected abstract PlaceholderMap getPlaceholders(S var1);

    protected abstract void setPlaceholders(S var1, PlaceholderMap var2);

    private boolean hasChildren(S station) {
        return this.getChildren(station).length > 0;
    }

    protected abstract D[] getChildren(S var1);

    public void read(PlaceholderMap map, PlaceholderListItemConverter<D, P> converter) {
        this.read(map, converter, false);
    }

    protected void read(PlaceholderMap map, PlaceholderListItemConverter<D, P> converter, boolean simulate) {
        if (converter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        if (!map.getFormat().equals(PLACEHOLDER_MAP_FORMAT)) {
            throw new IllegalArgumentException("unknown format: " + map.getFormat());
        }
        if (map.getVersion() != 0) {
            throw new IllegalArgumentException("version unknown: " + map.getVersion());
        }
        PlaceholderMap.Key[] placeholders = map.getPlaceholders();
        int n = placeholders.length;
        for (int i = 0; i < n; ++i) {
            int i$;
            Path[] list;
            HashSet<Path> paths = null;
            if (!simulate && (list = placeholders[i].getPlaceholders()).length > 0) {
                paths = new HashSet<Path>();
                for (Path path : list) {
                    paths.add(path);
                }
            }
            PlaceholderListItem dockable = null;
            if (map.contains(placeholders[i], "convert")) {
                Object[] keys;
                ConvertedPlaceholderListItem converted = new ConvertedPlaceholderListItem();
                Object[] arr$ = keys = map.getArray(placeholders[i], "convert-keys");
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    Object convertKey = arr$[i$];
                    String metaKey = (String)convertKey;
                    converted.put(metaKey, map.get(placeholders[i], "dock." + metaKey));
                }
                if (map.contains(placeholders[i], "map")) {
                    converted.setPlaceholderMap(map.getMap(placeholders[i], "map"));
                }
                dockable = (PlaceholderListItem)converter.convert(converted);
            }
            if (!simulate) {
                Item item = null;
                if (dockable == null) {
                    if (paths != null && !paths.isEmpty()) {
                        item = new Item(this, paths);
                    }
                } else {
                    item = new Item(this, dockable, paths, null);
                }
                if (item != null) {
                    if (map.contains(placeholders[i], "map")) {
                        item.setPlaceholderMap(map.getMap(placeholders[i], "map"));
                    }
                    if (map.contains(placeholders[i], "item")) {
                        Object[] keys;
                        Object[] arr$ = keys = map.getArray(placeholders[i], "item-keys");
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            Object itemKey = arr$[i$];
                            String key = (String)itemKey;
                            item.put(key, map.get(placeholders[i], "item." + key));
                        }
                    }
                    this.list().add(item);
                }
            }
            if (dockable == null) continue;
            converter.added(dockable);
        }
    }

    public PlaceholderMap toMap(PlaceholderListItemConverter<?, ? super P> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        PlaceholderMap map = new PlaceholderMap(PLACEHOLDER_MAP_FORMAT, 0);
        int dockableIndex = 0;
        for (Item entry : this.list()) {
            String[] itemKeys;
            Path[] placeholders;
            Set<Path> placeholderSet = entry.getPlaceholderSet();
            if (placeholderSet == null) {
                placeholderSet = Collections.emptySet();
            }
            placeholderSet = new HashSet<Path>(placeholderSet);
            PlaceholderMap placeholderMap = entry.getPlaceholderMap();
            Path additional = null;
            Object dockable = entry.getDockable();
            ConvertedPlaceholderListItem converted = null;
            if (dockable != null && (converted = converter.convert(dockableIndex, dockable)) != null) {
                additional = converted.getPlaceholder();
                PlaceholderMap convertedMap = converted.getPlaceholderMap();
                if (convertedMap != null) {
                    placeholderMap = convertedMap;
                }
            }
            if (!entry.isPlaceholder()) {
                ++dockableIndex;
            }
            if (additional != null) {
                placeholderSet.add(additional);
            }
            if ((placeholders = placeholderSet.toArray(new Path[placeholderSet.size()])).length <= 0 && converted == null) continue;
            PlaceholderMap.Key key = map.newUniqueKey(placeholders);
            map.add(key);
            if (placeholderMap != null) {
                map.put(key, "map", placeholderMap);
            }
            if (converted != null) {
                map.put(key, "convert", true);
                String[] keys = converted.keys();
                map.put(key, "convert-keys", keys);
                for (String metaKey : keys) {
                    map.put(key, "dock." + metaKey, converted.get(metaKey));
                }
            }
            if ((itemKeys = entry.keys()).length <= 0) continue;
            map.put(key, "item", true);
            map.put(key, "item-keys", itemKeys);
            for (String itemKey : itemKeys) {
                map.put(key, "item." + itemKey, entry.get(itemKey));
            }
        }
        return map;
    }

    public void bind() {
        if (!this.bound) {
            this.bound = true;
            if (this.strategy != null) {
                this.strategy.addListener(this.listener);
                for (Item item : this.list()) {
                    item.setStrategy(this.strategy);
                }
                this.checkAllPlaceholders();
            }
        }
    }

    public void unbind() {
        if (this.bound) {
            this.bound = false;
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
                for (Item item : this.list()) {
                    item.setStrategy(null);
                }
            }
        }
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(PlaceholderStrategy strategy) {
        if (this.bound) {
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
            }
            this.strategy = strategy;
            if (this.strategy != null) {
                this.strategy.addListener(this.listener);
            }
            for (Item item : this.list()) {
                item.setStrategy(strategy);
            }
            this.checkAllPlaceholders();
        } else {
            this.strategy = strategy;
        }
    }

    private void checkAllPlaceholders() {
        if (this.strategy != null) {
            Iterator iter = this.list().iterator();
            while (iter.hasNext()) {
                Item item = (Item)iter.next();
                Set<Path> placeholders = item.getPlaceholderSet();
                if (placeholders != null) {
                    Iterator<Path> paths = placeholders.iterator();
                    while (paths.hasNext()) {
                        if (this.strategy.isValidPlaceholder(paths.next())) continue;
                        paths.remove();
                    }
                }
                if (placeholders != null && !placeholders.isEmpty() || !item.isPlaceholder()) continue;
                iter.remove();
            }
        }
    }

    public void insertAllPlaceholders() {
        if (this.strategy != null) {
            for (Item item : this.list()) {
                Path placeholder;
                Object dockable = item.getDockable();
                if (dockable == null || (placeholder = this.getPlaceholder(dockable.asDockable())) == null) continue;
                item.add(placeholder);
            }
        }
    }

    public Filter<P> dockables() {
        return this.dockables;
    }

    public Filter<Set<Path>> purePlaceholders() {
        return this.purePlaceholders;
    }

    public Filter<Item> list() {
        return this.allItems;
    }

    public Filter<Set<Path>> listPlaceholders() {
        return this.allPlaceholders;
    }

    public void removeAll(Set<Path> placeholders) {
        Iterator iter = this.list().iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            item.removeAll(placeholders);
            if (item.getPlaceholderSet() != null || !item.isPlaceholder()) continue;
            iter.remove();
        }
    }

    public void removeAll(Path placeholder) {
        this.ensureRemoved(null, placeholder);
    }

    private void ensureRemoved(Item ignore, Path placeholder) {
        Iterator iter = this.list().iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (item == ignore) continue;
            item.remove(placeholder);
            if (item.getPlaceholderSet() != null || !item.isPlaceholder()) continue;
            iter.remove();
        }
    }

    public Path remove(int index) {
        Entry entry = this.search(index, Level.DOCKABLE);
        if (entry == null) {
            throw new IllegalArgumentException("no such dockable: " + index);
        }
        return this.removeDockable(entry);
    }

    public Path remove(P dockable) {
        Entry entry = this.search(dockable);
        if (entry == null) {
            return null;
        }
        return this.removeDockable(entry);
    }

    private Path removeDockable(Entry entry) {
        Object dockable = entry.item.getDockable();
        Path placeholder = this.getPlaceholder(dockable.asDockable());
        if (placeholder == null) {
            entry.item.setDockable(null);
        } else {
            entry.item.add(placeholder);
            entry.item.setDockable(null);
        }
        S station = this.toStation(dockable.asDockable());
        if (station != null) {
            PlaceholderMap map = this.getPlaceholders(station);
            entry.item.setPlaceholderMap(map);
            if (map != null) {
                for (PlaceholderMap.Key key : map.getPlaceholders()) {
                    for (Path keyPlaceholder : key.getPlaceholders()) {
                        entry.item.add(keyPlaceholder);
                    }
                }
            }
        }
        if (!entry.item.hasPlaceholders()) {
            entry.remove();
        }
        return placeholder;
    }

    public int put(Path placeholder, P dockable) {
        Path other;
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        Entry entry = this.search(placeholder);
        if (entry == null) {
            return -1;
        }
        entry.set(new Item(this, dockable, entry.item.getPlaceholderSet(), entry.item.getPlaceholderMap()));
        S station = this.toStation(dockable.asDockable());
        PlaceholderMap map = entry.item.getPlaceholderMap();
        if (station != null && map != null && !this.hasChildren(station)) {
            entry.item.setPlaceholderMap(null);
            this.setPlaceholders(station, map);
        }
        this.removeAll(placeholder);
        if (this.strategy != null && (other = this.getPlaceholder(dockable.asDockable())) != null && !other.equals(placeholder)) {
            this.removeAll(other);
        }
        return entry.index(Level.DOCKABLE);
    }

    public int getDockableIndex(Path placeholder) {
        Entry entry = this.search(placeholder);
        if (entry == null) {
            return -1;
        }
        while (entry != null && entry.item.isPlaceholder()) {
            entry = entry.previous(Level.BASE);
        }
        if (entry == null) {
            return 0;
        }
        return entry.index(Level.DOCKABLE) + 1;
    }

    public int getListIndex(Path placeholder) {
        Entry entry = this.search(placeholder);
        if (entry == null) {
            return -1;
        }
        return entry.index(Level.BASE);
    }

    public int getListIndex(int index, Path placeholder) {
        int result = -1;
        if (placeholder != null && (result = this.getListIndex(placeholder)) == -1) {
            this.insertAllPlaceholders();
            result = this.getListIndex(placeholder);
        }
        if (result == -1) {
            result = index;
        }
        result = Math.min(result, this.list().size());
        return result;
    }

    public int getNextListIndex(int index, Path placeholder) {
        int result = this.getListIndex(index, placeholder);
        ++result;
        result = Math.min(result, this.list().size());
        return result;
    }

    public boolean hasPlaceholder(Path placeholder) {
        return this.search(placeholder) != null;
    }

    public boolean put(P dockable, Path placeholder) {
        Entry entry = this.search(dockable);
        if (entry == null) {
            return false;
        }
        this.removeAll(placeholder);
        entry.item.add(placeholder);
        return true;
    }

    public P getDockableAt(Path placeholder) {
        Entry entry = this.search(placeholder);
        if (entry == null) {
            return null;
        }
        return entry.item.getDockable();
    }

    public PlaceholderMetaMap getMetaMap(Path placeholder) {
        Entry entry = this.search(placeholder);
        if (entry == null) {
            return null;
        }
        return entry.item;
    }

    public PlaceholderMap getMap(Path placeholder) {
        Entry entry = this.search(placeholder);
        if (entry == null) {
            return null;
        }
        return entry.item.placeholderMap;
    }

    public Item getItem(Path placeholder) {
        int index = this.getListIndex(placeholder);
        if (index == -1) {
            this.insertAllPlaceholders();
            index = this.getListIndex(placeholder);
        }
        if (index != -1) {
            return this.list().get(index);
        }
        return null;
    }

    public Item getItem(D dockable) {
        Entry entry = this.search((P)dockable);
        if (entry == null) {
            return null;
        }
        return entry.item;
    }

    public void addPlaceholder(D dockable, Path placeholder) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        Item item = this.getItem(dockable);
        if (item == null) {
            throw new IllegalArgumentException("unable to find item for dockable");
        }
        this.ensureRemoved(item, placeholder);
        item.add(placeholder);
    }

    public int size(Level level) {
        switch (level) {
            case BASE: {
                return this.list().size();
            }
            case DOCKABLE: {
                return this.dockables().size();
            }
            case PLACEHOLDER: {
                return this.purePlaceholders().size();
            }
        }
        throw new IllegalArgumentException("unknown level: " + (Object)((Object)level));
    }

    private Entry search(Path placeholder) {
        for (Entry entry = this.head; entry != null; entry = entry.next(Level.BASE)) {
            Set<Path> set = entry.item.getPlaceholderSet();
            if (set == null || !set.contains(placeholder)) continue;
            return entry;
        }
        return null;
    }

    private Entry search(D dockable) {
        for (Entry entry = this.head(Level.DOCKABLE); entry != null; entry = entry.next(Level.DOCKABLE)) {
            if (entry.item.getDockable().asDockable() != dockable) continue;
            return entry;
        }
        return null;
    }

    private Entry search(P dockable) {
        for (Entry entry = this.head(Level.DOCKABLE); entry != null; entry = entry.next(Level.DOCKABLE)) {
            if (entry.item.getDockable() != dockable) continue;
            return entry;
        }
        return null;
    }

    private Entry search(int index, Level level) {
        Entry entry;
        for (entry = this.head(level); entry != null && index > 0; entry = entry.next(level), --index) {
        }
        return entry;
    }

    public int baseToLevel(int index, Level level) {
        Entry entry = this.search(index, Level.BASE);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.index(level);
    }

    public int levelToBase(int index, Level level) {
        Entry entry = this.search(index, level);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.index(Level.BASE);
    }

    public void clear() {
        this.head = null;
        this.headDockable = null;
        this.headPlaceholder = null;
        this.invalidate();
    }

    private Entry head(Level level) {
        switch (level) {
            case BASE: {
                return this.head;
            }
            case PLACEHOLDER: {
                return this.headPlaceholder;
            }
            case DOCKABLE: {
                return this.headDockable;
            }
        }
        throw new IllegalArgumentException();
    }

    private void invalidate() {
        this.dockables.invalidate();
        this.allPlaceholders.invalidate();
        this.purePlaceholders.invalidate();
        this.allItems.invalidate();
    }

    public String toString() {
        return this.list().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SubList<A>
    implements Filter<A> {
        private Level level;
        private int size = -1;

        protected abstract A unwrap(Item var1);

        protected abstract Item wrap(A var1);

        protected abstract boolean visible(Item var1);

        public SubList(Level level) {
            this.level = level;
        }

        public PlaceholderList<D, S, P> getPlaceholderList() {
            return PlaceholderList.this;
        }

        public void invalidate() {
            this.size = -1;
        }

        private Entry getEntry(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0: " + index);
            }
            Entry entry = PlaceholderList.this.head(this.level);
            int start = index;
            while (index > 0) {
                entry = entry.next(this.level);
                --index;
                if (entry != null) continue;
                throw new IndexOutOfBoundsException("index=" + start + ", size=" + this.size());
            }
            return entry;
        }

        @Override
        public void add(A object) {
            this.add(this.size(), object);
        }

        @Override
        public void add(int index, A object) {
            this.insert(index, this.wrap(object));
        }

        @Override
        public void insertPlaceholder(int index, Path placeholder) {
            if (placeholder == null) {
                throw new IllegalArgumentException("placeholder must not be null");
            }
            HashSet<Path> placeholders = new HashSet<Path>();
            placeholders.add(placeholder);
            this.insert(index, new Item(PlaceholderList.this, placeholders));
        }

        @Override
        public void addPlaceholder(int index, Path placeholder) {
            Entry entry = PlaceholderList.this.search(index, this.level);
            if (entry == null) {
                throw new IndexOutOfBoundsException();
            }
            if (!entry.item.hasPlaceholder(placeholder)) {
                PlaceholderList.this.removeAll(placeholder);
                entry.item.add(placeholder);
            }
        }

        private void insert(int index, Item item) {
            if (this.size() == index) {
                Entry entry = PlaceholderList.this.head;
                Entry predecessor = null;
                while (entry != null) {
                    predecessor = entry;
                    entry = entry.next;
                }
                new Entry(predecessor, item);
            } else {
                Entry entry = this.getEntry(index);
                new Entry(entry.previous(this.level), item);
            }
        }

        @Override
        public PlaceholderMetaMap getMetaMap(int index) {
            return this.getEntry(index).item;
        }

        @Override
        public A get(int index) {
            return this.unwrap(this.getEntry(index).item);
        }

        @Override
        public int indexOf(A object) {
            int index = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (this.unwrap(entry.item).equals(object)) {
                    return index;
                }
                entry = entry.next(this.level);
                ++index;
            }
            return -1;
        }

        @Override
        public int indexOfPlaceholder(Path placeholder) {
            int index = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (entry.item.hasPlaceholder(placeholder)) {
                    return index;
                }
                entry = entry.next(this.level);
                ++index;
            }
            return -1;
        }

        @Override
        public A remove(int index) {
            Entry entry = this.getEntry(index);
            entry.remove();
            return this.unwrap(entry.item);
        }

        @Override
        public int remove(A object) {
            int index = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (this.unwrap(entry.item).equals(object)) {
                    entry.remove();
                    return index;
                }
                entry = entry.next(this.level);
                ++index;
            }
            return -1;
        }

        @Override
        public A set(int index, A object) {
            Entry entry = this.getEntry(index);
            A result = this.unwrap(entry.item);
            entry.set(this.wrap(object));
            return result;
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = 0;
                for (Entry entry = PlaceholderList.this.head(this.level); entry != null; entry = entry.next(this.level)) {
                    ++this.size;
                }
            }
            return this.size;
        }

        @Override
        public void move(int source, int destination) {
            Entry entry = PlaceholderList.this.search(source, this.level);
            if (entry == null) {
                throw new IllegalArgumentException("no entry for index: " + source);
            }
            int delta = destination - source;
            entry.move(delta, this.level);
        }

        @Override
        public void move(Filter<A> sourceList, int sourceIndex, int destination) {
            if (sourceList == this) {
                this.move(sourceIndex, destination);
                return;
            }
            if (!(sourceList instanceof SubList)) {
                throw new IllegalArgumentException("The type " + sourceList.getClass().getName() + " is not recognized");
            }
            SubList list = (SubList)sourceList;
            if (list.getPlaceholderList() == this.getPlaceholderList()) {
                sourceIndex = PlaceholderList.this.levelToBase(sourceIndex, list.level);
                destination = PlaceholderList.this.levelToBase(destination, this.level);
                list.move(sourceIndex, destination);
                return;
            }
            Entry entry = list.getPlaceholderList().search(sourceIndex, list.level);
            if (entry == null) {
                throw new IllegalArgumentException("sourceIndex out of bounds: " + sourceIndex);
            }
            if ((destination = destination == this.size() ? PlaceholderList.this.list().size() : PlaceholderList.this.levelToBase(destination, this.level)) < 0 || destination > PlaceholderList.this.list().size()) {
                throw new IllegalArgumentException("destination out of bounds: " + destination);
            }
            PlaceholderMap map = entry.item.placeholderMap;
            Set placeholderSet = entry.item.placeholderSet;
            PlaceholderListItem value = entry.item.value;
            entry.remove();
            Item item = new Item(PlaceholderList.this, value, placeholderSet, map);
            PlaceholderList.this.list().add(destination, item);
            if (PlaceholderList.this.bound) {
                item.setStrategy(PlaceholderList.this.getStrategy());
                PlaceholderList.this.checkAllPlaceholders();
            }
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(){
                private Entry current = null;
                private Entry next;
                {
                    this.next = PlaceholderList.this.head(SubList.this.level);
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public A next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    this.current = this.next;
                    this.next = this.next.next(SubList.this.level);
                    return SubList.this.unwrap(this.current.item);
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    this.current.remove();
                    this.current = null;
                }
            };
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (A value : this) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(value);
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<M>
    extends Iterable<M> {
        public int size();

        public M get(int var1);

        public PlaceholderMetaMap getMetaMap(int var1);

        public void add(M var1);

        public void add(int var1, M var2);

        public void addPlaceholder(int var1, Path var2);

        public void insertPlaceholder(int var1, Path var2);

        public M set(int var1, M var2);

        public M remove(int var1);

        public int remove(M var1);

        public int indexOf(M var1);

        public int indexOfPlaceholder(Path var1);

        public void move(int var1, int var2);

        public void move(Filter<M> var1, int var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Item
    extends PlaceholderMetaMap {
        private P value;
        private Set<Path> placeholderSet;
        private PlaceholderMap placeholderMap;
        private Entry owner;
        final /* synthetic */ PlaceholderList this$0;

        public Item(P dockable) {
            this.this$0 = var1_1;
            this.placeholderSet = null;
            if (dockable == null) {
                throw new IllegalArgumentException("dockable must not be null");
            }
            this.value = dockable;
        }

        public Item(P dockable, Set<Path> placeholderSet, PlaceholderMap placeholderMap) {
            this.this$0 = var1_1;
            this.placeholderSet = null;
            if (dockable == null) {
                throw new IllegalArgumentException("dockable must not be null");
            }
            this.value = dockable;
            this.placeholderMap = placeholderMap;
            this.setPlaceholderSet(placeholderSet);
        }

        public Item(PlaceholderList placeholderList, Set<Path> placeholders) {
            this.this$0 = placeholderList;
            this.placeholderSet = null;
            if (placeholders == null || placeholders.isEmpty()) {
                throw new IllegalArgumentException("placeholder must not be null nor empty");
            }
            this.setPlaceholderSet(placeholders);
        }

        public void setStrategy(PlaceholderStrategy strategy) {
            if (this.placeholderMap != null) {
                this.placeholderMap.setPlaceholderStrategy(strategy);
            }
        }

        protected void setOwner(Entry owner) {
            if (this.this$0.bound && this.this$0.strategy != null && this.placeholderMap != null) {
                if (owner == null) {
                    this.placeholderMap.setPlaceholderStrategy(null);
                } else {
                    this.placeholderMap.setPlaceholderStrategy(this.this$0.strategy);
                }
            }
            this.owner = owner;
        }

        public boolean isPlaceholder() {
            return this.value == null;
        }

        public Set<Path> getPlaceholderSet() {
            return this.placeholderSet;
        }

        public void setPlaceholderSet(Set<Path> placeholderSet) {
            if (placeholderSet != null && placeholderSet.contains(null)) {
                throw new IllegalArgumentException("placeholderSet contains a null value");
            }
            this.placeholderSet = placeholderSet;
        }

        public void removeAll(Set<Path> placeholders) {
            if (this.placeholderSet != null) {
                this.placeholderSet.removeAll(placeholders);
                if (this.placeholderSet.isEmpty()) {
                    this.placeholderSet = null;
                }
            }
            if (this.placeholderMap != null) {
                this.placeholderMap.removeAll(placeholders, true);
                if (this.placeholderMap.isEmpty()) {
                    this.setPlaceholderMap(null);
                }
            }
        }

        public void remove(Path placeholder) {
            if (this.placeholderSet != null) {
                this.placeholderSet.remove(placeholder);
                if (this.placeholderSet.isEmpty()) {
                    this.placeholderSet = null;
                }
            }
            if (this.placeholderMap != null) {
                this.placeholderMap.removeAll(placeholder, true);
                if (this.placeholderMap.isEmpty()) {
                    this.setPlaceholderMap(null);
                }
            }
        }

        public void add(Path placeholder) {
            if (placeholder == null) {
                throw new IllegalArgumentException("placeholder must not be null");
            }
            if (this.placeholderSet == null) {
                this.placeholderSet = new HashSet<Path>();
            }
            this.placeholderSet.add(placeholder);
        }

        public boolean hasPlaceholders() {
            return this.placeholderSet != null && !this.placeholderSet.isEmpty();
        }

        public boolean hasPlaceholder(Path placeholder) {
            return this.placeholderSet != null && this.placeholderSet.contains(placeholder);
        }

        public P getDockable() {
            return this.value;
        }

        public void setDockable(P dockable) {
            this.value = dockable;
            this.owner.refresh();
        }

        public void setPlaceholderMap(PlaceholderMap placeholders) {
            if (this.this$0.bound && this.this$0.strategy != null) {
                if (this.placeholderMap != null) {
                    this.placeholderMap.setPlaceholderStrategy(null);
                }
                this.placeholderMap = placeholders;
                if (this.placeholderMap != null) {
                    this.placeholderMap.setPlaceholderStrategy(this.this$0.strategy);
                }
            } else {
                this.placeholderMap = placeholders;
            }
        }

        public PlaceholderMap getPlaceholderMap() {
            return this.placeholderMap;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(dockable=");
            if (this.value != null) {
                builder.append(this.this$0.toString(this.value.asDockable()));
            }
            builder.append(", placeholders={");
            if (this.placeholderSet != null) {
                boolean first = true;
                for (Path path : this.placeholderSet) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(path.toString());
                }
            }
            builder.append("})");
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        private Item item;
        private boolean itemWasPlaceholder;
        private Entry next;
        private Entry previous;
        private Entry nextLevel;
        private Entry previousLevel;

        public Entry(Entry predecessor, Item item) {
            this.item = item;
            this.insertAfter(predecessor);
        }

        public void insertAfter(Entry predecessor) {
            PlaceholderList.this.invalidate();
            this.item.setOwner(this);
            this.itemWasPlaceholder = this.item.isPlaceholder();
            Entry predecessorLevel = null;
            if (predecessor == null) {
                this.next = PlaceholderList.this.head;
                if (PlaceholderList.this.head != null) {
                    ((PlaceholderList)PlaceholderList.this).head.previous = this;
                }
                PlaceholderList.this.head = this;
                predecessorLevel = null;
            } else {
                this.next = predecessor.next;
                if (this.next != null) {
                    this.next.previous = this;
                }
                predecessor.next = this;
                this.previous = predecessor;
                for (Entry search = predecessor; search != null && predecessorLevel == null; search = search.previous(Level.BASE)) {
                    if (search.item.isPlaceholder() != this.item.isPlaceholder()) continue;
                    predecessorLevel = search;
                }
            }
            Entry successorLevel = null;
            if (predecessorLevel == null) {
                if (this.item.isPlaceholder()) {
                    successorLevel = PlaceholderList.this.headPlaceholder;
                    PlaceholderList.this.headPlaceholder = this;
                } else {
                    successorLevel = PlaceholderList.this.headDockable;
                    PlaceholderList.this.headDockable = this;
                }
            }
            if (predecessorLevel != null) {
                this.previousLevel = predecessorLevel;
                this.nextLevel = predecessorLevel.nextLevel;
                if (this.nextLevel != null) {
                    this.nextLevel.previousLevel = this;
                }
                this.previousLevel.nextLevel = this;
            } else if (successorLevel != null) {
                this.nextLevel = successorLevel;
                successorLevel.previousLevel = this;
            }
        }

        public void move(int delta, Level level) {
            if (delta == 0) {
                return;
            }
            Entry newPredecessor = this;
            if (delta > 0) {
                for (int i = 0; i < delta; ++i) {
                    if ((newPredecessor = newPredecessor.next(level)) != null) continue;
                    throw new IllegalArgumentException("delta too big");
                }
            } else {
                for (int i = -delta; i >= 0; --i) {
                    if (newPredecessor == null) {
                        throw new IllegalArgumentException("delta too big");
                    }
                    newPredecessor = newPredecessor.previous(level);
                }
            }
            this.remove();
            this.insertAfter(newPredecessor);
        }

        public Entry next(Level level) {
            switch (level) {
                case BASE: {
                    return this.next;
                }
                case PLACEHOLDER: {
                    return this.item.isPlaceholder() ? this.nextLevel : null;
                }
                case DOCKABLE: {
                    return this.item.isPlaceholder() ? null : this.nextLevel;
                }
            }
            throw new IllegalArgumentException();
        }

        public Entry previous(Level level) {
            switch (level) {
                case BASE: {
                    return this.previous;
                }
                case PLACEHOLDER: {
                    return this.item.isPlaceholder() ? this.previousLevel : null;
                }
                case DOCKABLE: {
                    return this.item.isPlaceholder() ? null : this.previousLevel;
                }
            }
            throw new IllegalArgumentException();
        }

        public int index(Level level) {
            Entry entry = PlaceholderList.this.head(level);
            int index = 0;
            while (entry != this && entry != null) {
                entry = entry.next(level);
                ++index;
            }
            if (entry == null) {
                return -1;
            }
            return index;
        }

        public void refresh() {
            this.set(this.item);
        }

        public void set(Item item) {
            this.item.setOwner(null);
            item.setOwner(this);
            if (this.itemWasPlaceholder != item.isPlaceholder()) {
                this.itemWasPlaceholder = item.isPlaceholder();
                PlaceholderList.this.invalidate();
                this.removeLevel();
                Entry levelPredecessor = this.findLevelPredecessor(item.isPlaceholder());
                Entry levelSuccessor = this.findLevelSuccessor(item.isPlaceholder());
                if (levelPredecessor == null) {
                    if (item.isPlaceholder()) {
                        PlaceholderList.this.headPlaceholder = this;
                    } else {
                        PlaceholderList.this.headDockable = this;
                    }
                    this.previousLevel = null;
                } else {
                    levelPredecessor.nextLevel = this;
                    this.previousLevel = levelPredecessor;
                }
                if (levelSuccessor != null) {
                    this.nextLevel = levelSuccessor;
                    levelSuccessor.previousLevel = this;
                } else {
                    this.nextLevel = null;
                }
            }
            this.item = item;
        }

        private Entry findLevelPredecessor(boolean placeholder) {
            Entry entry = this.previous;
            while (entry != null) {
                if (entry.item.isPlaceholder() == placeholder) {
                    return entry;
                }
                entry = entry.previous;
            }
            return null;
        }

        private Entry findLevelSuccessor(boolean placeholder) {
            Entry entry = this.next;
            while (entry != null) {
                if (entry.item.isPlaceholder() == placeholder) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public void remove() {
            PlaceholderList.this.invalidate();
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            if (this == PlaceholderList.this.head) {
                PlaceholderList.this.head = this.next;
            }
            this.next = null;
            this.previous = null;
            this.item.setOwner(null);
            this.removeLevel();
        }

        private void removeLevel() {
            PlaceholderList.this.invalidate();
            if (this.nextLevel != null) {
                this.nextLevel.previousLevel = this.previousLevel;
            }
            if (this.previousLevel != null) {
                this.previousLevel.nextLevel = this.nextLevel;
            }
            if (this == PlaceholderList.this.headDockable) {
                PlaceholderList.this.headDockable = this.nextLevel;
            }
            if (this == PlaceholderList.this.headPlaceholder) {
                PlaceholderList.this.headPlaceholder = this.nextLevel;
            }
            this.nextLevel = null;
            this.previousLevel = null;
        }

        public String toString() {
            return this.item.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        BASE,
        DOCKABLE,
        PLACEHOLDER;

    }
}

