/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui.filters;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.SearchFilter;
import java.awt.event.ActionEvent;

public abstract class AbstractFilterAction
extends NavigatorAction {
    private final SearchFilter _searchFilter;
    private final NavigatorFileTree _fileTree;

    public AbstractFilterAction(SearchFilter searchFltr, String iconName, NavigatorFileTree navigatorFileTree) {
        super(AbstractFilterAction.nameByFilter(searchFltr), iconName, null);
        this._searchFilter = searchFltr;
        this._fileTree = navigatorFileTree;
    }

    private static String nameByFilter(SearchFilter searchFilter) {
        return searchFilter.getName();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name = AbstractFilterAction.nameByFilter(this._searchFilter);
        boolean doActivate = this._fileTree.getFileFilterByName(name) == null;
        this.putValue("active", doActivate);
        if (doActivate) {
            this._fileTree.activateFileFilter(this._searchFilter);
            this._fileTree.notifyObservers();
            return;
        }
        this._fileTree.deactivateFileFilter(name);
        this._fileTree.notifyObservers();
    }
}

