/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.DrawingHelper;
import CH.ifa.draw.util.Palette;
import de.renew.gui.GuiPlugin;
import de.renew.netcomponents.ComponentsPluginExtender;
import de.renew.netcomponents.ComponentsToolPlugin;
import de.renew.netcomponents.InsertionTool;
import de.renew.util.StringUtil;
import de.renew.windowmanagement.Workbench;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class ComponentsTool
implements StatusDisplayer {
    public static final Logger LOGGER = Logger.getLogger(ComponentsTool.class);
    protected static final String TOOLDIRPROPERTY = "user.toolsdir";
    private Palette _palette;
    private String _label;
    private boolean _toolsDirCheck = false;
    private boolean _toolsDirIsSet = false;

    public ComponentsTool(Workbench workbench) {
        Object dirName = System.getProperty(TOOLDIRPROPERTY);
        LOGGER.debug(dirName);
        if (dirName == null || !new File((String)dirName).exists()) {
            URL location = ComponentsToolPlugin.getLocation();
            Object toolsLoc = new File(location.getFile()).getAbsolutePath();
            if (new File((String)(toolsLoc = ((String)toolsLoc).substring(0, ((String)toolsLoc).lastIndexOf(File.separator)) + File.separator + "tools")).exists()) {
                dirName = toolsLoc;
                this._toolsDirIsSet = true;
                String statusMessage = "The user.toolsdir property is not set or not valid. Trying plugin location...";
                GuiPlugin.getCurrent().showStatus(statusMessage);
                LOGGER.debug((Object)statusMessage);
            } else {
                this._toolsDirIsSet = false;
                dirName = "";
                LOGGER.info((Object)"Netcomponents: The user.toolsdir is not set! \nOverride by setting the user.toolsdir property.");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("netcomponents: using default tooldir '" + (String)dirName + "'.Override by setting the user.toolsdir property."));
                }
            }
        } else {
            this._toolsDirIsSet = true;
        }
        this.setLabel("default " + (String)dirName);
        this.createTools((String)dirName, "Components", null, workbench);
    }

    public ComponentsTool(String dirName, String paletteName, ComponentsPluginExtender plugin, Workbench workbench) {
        this._toolsDirIsSet = true;
        this.setLabel(dirName);
        this.createTools(dirName, paletteName, plugin, workbench);
    }

    void createTools(String dirName, String paletteName, ComponentsPluginExtender plugin, Workbench workbench) {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter == null) {
            LOGGER.error((Object)"ComponentsPlugin: no GuiPlugin available!");
            return;
        }
        this._palette = new Palette(paletteName);
        LinkedHashMap toolsList = new LinkedHashMap();
        File dir = new File(dirName);
        File imageDir = new File(dirName + File.separator + "images");
        Vector<String> vSeq = new Vector<String>();
        try {
            BufferedReader seq = new BufferedReader(new FileReader(dirName + File.separator + ".sequence"));
            while (seq.ready()) {
                vSeq.add(seq.readLine());
            }
            seq.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)("The File" + dirName + File.separator + ".sequence could not be found " + String.valueOf(e)));
        }
        if (dir.isDirectory()) {
            if (imageDir.isDirectory()) {
                String[] fileNames = dir.list();
                for (int i = 0; i < fileNames.length; ++i) {
                    String s = StringUtil.getFilename((String)fileNames[i]);
                    String ext = StringUtil.getExtension((String)fileNames[i]);
                    if (!new File(dirName + File.separator + fileNames[i]).isFile() || !"rnw".equals(ext) || vSeq.contains(s)) continue;
                    vSeq.add(s);
                }
                if (new File(dirName + File.separator + "images" + File.separator + "generic.gif").exists()) {
                    Vector<ToolButton> additionalButtons;
                    for (String toolName : vSeq) {
                        String fileName = toolName + ".rnw";
                        Drawing drawing = DrawingFileHelper.loadDrawing((File)new File(dirName, fileName), (StatusDisplayer)this);
                        Drawing drawing2 = null;
                        try {
                            drawing2 = DrawingHelper.cloneDrawing((Drawing)drawing);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ToolButton button = this.createToolButton(toolName, dirName, starter, drawing2);
                        if (button != null) {
                            this._palette.add(button);
                            FigureEnumeration figures = drawing.figures();
                            Vector<Figure> figureVector = new Vector<Figure>();
                            int upperBounds = 0;
                            int leftBounds = 0;
                            while (figures.hasMoreElements()) {
                                Figure figure = figures.nextFigure();
                                Point center = figure.center();
                                Rectangle displayBox = figure.displayBox();
                                int newUpperBounds = center.y - displayBox.height / 2;
                                int newLeftBounds = center.x - displayBox.width / 2;
                                if (newUpperBounds < upperBounds) {
                                    upperBounds = newUpperBounds;
                                }
                                if (newLeftBounds < leftBounds) {
                                    leftBounds = newLeftBounds;
                                }
                                figureVector.add(figure);
                            }
                            StandardDrawingView.moveFigures(figureVector, (int)Math.abs(leftBounds), (int)Math.abs(upperBounds));
                            Dimension d = drawing.defaultSize();
                            BufferedImage image = new BufferedImage(d.width, d.height, 2);
                            Graphics2D g = image.createGraphics();
                            drawing.draw((Graphics)g);
                            JLabel label = new JLabel(new ImageIcon(image));
                            JScrollPane scrollPane = new JScrollPane(label, 22, 32);
                            scrollPane.getViewport().setScrollMode(1);
                            scrollPane.getVerticalScrollBar().setUnitIncrement(20);
                            scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
                            scrollPane.setPreferredSize(new Dimension(300, 300));
                            button.addAdditionalComponent((Component)scrollPane);
                        }
                        this._toolsDirCheck = true;
                    }
                    if (plugin != null && (additionalButtons = plugin.getAdditionalButtons()) != null) {
                        for (ToolButton toolButton : additionalButtons) {
                            this._palette.add(toolButton);
                        }
                    }
                    if (this.toolsDirIsValid()) {
                        starter.getPaletteHolder().addPalette(this._palette);
                    }
                } else {
                    LOGGER.error((Object)("The directory " + dirName + File.separator + "images seems to exist"));
                    LOGGER.error((Object)"but it does not contain the files generic.gif");
                    LOGGER.error((Object)"So I think that the toolsdir variable is not set to a proper toolsdir directory");
                    LOGGER.error((Object)"or the selected directory does not match the requirements.");
                    LOGGER.error((Object)"A proper toolsdir directory contains the images directory  ");
                    LOGGER.error((Object)"which contains at least the file generic.gif as fallback and a .sequence file.");
                    LOGGER.error((Object)"");
                }
            } else {
                LOGGER.error((Object)("The directory " + dirName + File.separator + "images does not exist!"));
            }
        } else {
            LOGGER.error((Object)("The directory " + dirName + " does not exist!"));
        }
    }

    private ToolButton createToolButton(String toolName, String dirName, GuiPlugin starter, Drawing drawing) {
        String fileName = toolName + ".rnw";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(ComponentsTool.class.getName() + ": dirName: " + dirName));
            LOGGER.debug((Object)(ComponentsTool.class.getName() + ": fileName: " + fileName));
        }
        if (drawing == null) {
            return null;
        }
        Tool tool = this.createInsertionTool(starter, drawing);
        String imageName = "";
        String toolBase = dirName + File.separator + "images" + File.separator;
        File imageFile = new File(toolBase + toolName + ".gif");
        File selFile = new File(toolBase + toolName + ".gif");
        if (imageFile.exists() && selFile.exists()) {
            imageName = toolName;
        } else {
            imageName = "generic";
            LOGGER.warn((Object)("File does not exist: " + imageFile.getAbsolutePath() + " trying to load generic.gif instead."));
        }
        ToolButton button = starter.getPaletteHolder().createToolButton(toolBase + imageName, "NC " + toolName, tool);
        return button;
    }

    private Tool createInsertionTool(GuiPlugin starter, Drawing drawing) {
        DrawingEditor editor = starter.getDrawingEditor();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("ComponentsTool: " + String.valueOf(drawing)));
        }
        FigureEnumeration fe = drawing.figures();
        Vector<Figure> v = new Vector<Figure>();
        while (fe.hasMoreElements()) {
            v.addElement((Figure)fe.nextElement());
        }
        InsertionTool tool = new InsertionTool(editor, v);
        return tool;
    }

    public void remove() {
        GuiPlugin starter = GuiPlugin.getCurrent();
        if (starter != null) {
            starter.getPaletteHolder().removePalette(this._palette);
        }
    }

    private void setLabel(String s) {
        this._label = s;
    }

    public String getLabel() {
        return this._label;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean toolsDirIsSet() {
        return this._toolsDirIsSet;
    }

    public boolean toolsDirIsValid() {
        return this._toolsDirCheck;
    }

    public void showStatus(String message) {
        LOGGER.warn((Object)(ComponentsTool.class.getSimpleName() + ": A file could not be loaded."));
        LOGGER.warn((Object)(ComponentsTool.class.getSimpleName() + ": Turn on debug to display more information."));
        LOGGER.warn((Object)(ComponentsTool.class.getSimpleName() + ": To do so add line log4j.logger.de.renew.netcomponents.ComponentsTool=DEBUG"));
        LOGGER.warn((Object)(ComponentsTool.class.getSimpleName() + ": to your log4j configuration in e.g. ~/.log4j.properties."));
        LOGGER.debug((Object)message);
    }
}

