/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulatorPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.RemoteServerRegistryListener;
import de.renew.remote.Server;
import de.renew.remote.ServerImpl;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RemoteServerRegistry {
    public static final Logger LOGGER = Logger.getLogger(RemoteServerRegistry.class);
    private static RemoteServerRegistry _instance = null;
    private Vector<ServerDescriptor> _servers = new Vector();
    private Set<RemoteServerRegistryListener> _listeners = new HashSet<RemoteServerRegistryListener>();
    private Map<Remote, String> _remoteObjects = new HashMap<Remote, String>();

    private RemoteServerRegistry() {
    }

    public static RemoteServerRegistry instance() {
        if (_instance == null) {
            _instance = new RemoteServerRegistry();
        }
        return _instance;
    }

    public ServerDescriptor connectServer(String host, String name) throws NotBoundException, RemoteException {
        RemotePlugin.configureInterface();
        Server server = ServerImpl.getInstance(host, name);
        ServerDescriptor desc = new ServerDescriptor(host, name, server);
        this._servers.add(desc);
        this.fireConnectedTo(desc);
        return desc;
    }

    public void removeServer(int index) {
        ServerDescriptor desc = this._servers.get(index);
        this.fireDisconnectedFrom(desc);
        this._servers.remove(index);
    }

    public ServerDescriptor getServerDescriptor(int index) {
        return this._servers.elementAt(index);
    }

    public ServerDescriptor[] allServers() {
        return this._servers.toArray(new ServerDescriptor[this._servers.size()]);
    }

    public NetInstanceAccessor[] allNetInstances(int index) throws RemoteException {
        Server server = this.getServer(index);
        return server.getSimulator().getNetInstances();
    }

    public Server getServer(int index) {
        return this._servers.elementAt(index).getServer();
    }

    public void addRegistryListener(RemoteServerRegistryListener listener) {
        this._listeners.add(listener);
    }

    public void catchUpOnPreviousConnects(RemoteServerRegistryListener listener) {
        if (!this._listeners.contains(listener)) {
            throw new IllegalArgumentException("Listener must have been registered before catching up.");
        }
        for (ServerDescriptor server : this._servers) {
            listener.connectedTo(server);
        }
    }

    public boolean registerObjectIfPossible(String serviceName, Remote object, Properties activeProperties) {
        boolean success = false;
        try {
            success = this.registerObject(serviceName, object, activeProperties);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)("Could not bind " + serviceName + " service to registry: " + String.valueOf(e)));
        }
        return success;
    }

    public boolean registerObjectIfPossible(String serviceName, Remote object) {
        PluginProperties activeProperties = ((SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next()).getProperties();
        return this.registerObjectIfPossible(serviceName, object, (Properties)activeProperties);
    }

    public boolean registerObject(String serviceName, Remote object, Properties activeProperties) throws RemoteException {
        boolean success = false;
        if (PropertyHelper.getBoolProperty((Properties)activeProperties, (String)"de.renew.remote.enable")) {
            String serverName = activeProperties.getProperty("de.renew.remote.publicName");
            Object serverURL = "";
            if (serverName == null) {
                serverName = "default";
            }
            try {
                serverURL = "//localhost/" + serviceName + "." + serverName;
                Naming.rebind((String)serverURL, object);
                LOGGER.info((Object)(serviceName + " service bound to " + (String)serverURL + "."));
                this._remoteObjects.put(object, (String)serverURL);
                success = true;
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("Could not bind " + serviceName + " service to " + (String)serverURL + ": " + String.valueOf(e)));
                serverURL = null;
            }
        }
        return success;
    }

    public boolean registerObject(String serviceName, Remote object) throws RemoteException {
        PluginProperties activeProperties = ((SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next()).getProperties();
        return this.registerObject(serviceName, object, (Properties)activeProperties);
    }

    public void unregisterObject(Remote object) {
        String serverURL = this._remoteObjects.get(object);
        if (serverURL != null) {
            try {
                Naming.unbind(serverURL);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("Could not unbind object: " + String.valueOf(e)));
            }
            catch (RemoteException e) {
                LOGGER.error((Object)("Could not unbind object: " + String.valueOf(e)));
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
            serverURL = null;
        }
    }

    public void removeRegistryListener(RemoteServerRegistryListener listener) {
        this._listeners.remove(listener);
    }

    private void fireConnectedTo(ServerDescriptor desc) {
        Iterator<RemoteServerRegistryListener> listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().connectedTo(desc);
        }
    }

    private void fireDisconnectedFrom(ServerDescriptor desc) {
        Iterator<RemoteServerRegistryListener> listeners = this._listeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().disconnectedFrom(desc);
        }
    }

    public class ServerDescriptor {
        private String _host;
        private String _name;
        private Server _server;

        public ServerDescriptor(String host, String name, Server server) {
            this._host = host;
            this._name = name;
            this._server = server;
        }

        public String getUrl(String service) {
            return "//" + this._host + "/" + service + "." + this._name;
        }

        public String getHost() {
            return this._host;
        }

        public String getName() {
            return this._name;
        }

        public Server getServer() {
            return this._server;
        }

        public String toString() {
            return "//" + this.getHost() + "/" + this.getName();
        }
    }
}

