/*
 * Decompiled with CFR 0.152.
 */
package de.renew.watch;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerCollectionImpl;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.EmptyIterator;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import de.renew.util.Semaphor;
import de.renew.watch.ChannelWatcher;
import de.renew.watch.ParamFinder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ChannelSupervisor
implements Triggerable,
Serializable,
DelayedFieldOwner {
    public static Logger _logger = Logger.getLogger(ChannelSupervisor.class);
    static final long serialVersionUID = 8023504578713732407L;
    private static final LinkedList<ChannelSupervisor> DIRTY_SUPERVISORS = new LinkedList();
    private static final List<ChannelSupervisor> ALL_SUPERVISORS = Collections.synchronizedList(new LinkedList());
    private static Semaphor _dirtySem = new Semaphor();
    private static SupervisorThread _supervisorThread;
    private final transient NetInstance _netInstance;
    private final transient ChannelWatcher _watcher;
    private final transient String _channel;
    private final transient Class<?> _lateClass;
    private TriggerCollection _triggers;
    private transient boolean _valid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelSupervisor(NetInstance netInstance, ChannelWatcher watcher, String channel, Class<?> lateClass) {
        this._netInstance = netInstance;
        this._watcher = watcher;
        this._channel = channel;
        this._lateClass = lateClass;
        this._valid = true;
        this._triggers = new TriggerCollectionImpl((Triggerable)this);
        List<ChannelSupervisor> list = ALL_SUPERVISORS;
        synchronized (list) {
            ALL_SUPERVISORS.add(0, this);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("New " + this.toString() + "."));
        }
        this.proposeSearch();
    }

    public boolean execute(final Object early, final Object late, final StepIdentifier stepIdentifier) {
        block5: {
            if (this._valid) {
                Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        ExecuteFinder finder = new ExecuteFinder();
                        Tuple paramTuple = new Tuple(new Object[]{early, late}, null);
                        Variable variable = new Variable((Object)paramTuple, null);
                        Searcher searcher = new Searcher();
                        searcher.initiatedSearch((ChannelTarget)ChannelSupervisor.this._netInstance, ChannelSupervisor.this._channel, variable, false, (Finder)finder, null);
                        boolean success = finder.isCompleted();
                        if (success) {
                            finder.execute(stepIdentifier, true);
                        }
                        return success;
                    }
                });
                try {
                    return (Boolean)future.get();
                }
                catch (InterruptedException e) {
                    _logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
                    break block5;
                }
                catch (ExecutionException e) {
                    _logger.error((Object)"Simulation thread threw an exception", (Throwable)e);
                    break block5;
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Call to execute on invalid ChannelSupervisor:" + this.toString() + ", parameters: early=" + String.valueOf(early) + ", late=" + String.valueOf(late) + ", step=" + String.valueOf(stepIdentifier)), new Throwable("DEBUG STACKTRACE"));
            }
        }
        return false;
    }

    public TriggerCollection triggers() {
        return this._triggers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proposeSearch() {
        if (this._valid) {
            List<ChannelSupervisor> list = ALL_SUPERVISORS;
            synchronized (list) {
                DIRTY_SUPERVISORS.addLast(this);
                this._triggers.clear();
            }
            _dirtySem.V();
        } else {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Call to proposeSearch on invalid ChannelSupervisor:" + this.toString() + ". Clearing trigger collection."));
            }
            this._triggers.clear();
        }
    }

    void update() {
        if (this._valid) {
            final ChannelSupervisor object = this;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Initiating update on " + this.toString() + "..."));
            }
            Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    Tuple arguments = new Tuple(2);
                    Variable earlyVariable = new Variable(arguments.getComponent(0), null);
                    Searcher searcher = new Searcher();
                    try {
                        searcher.calcChecker.addEarlyVariable(earlyVariable, null);
                        searcher.calcChecker.addCalculated(ChannelSupervisor.this._lateClass, arguments.getComponent(1), null, null);
                    }
                    catch (Impossible e) {
                        throw new RuntimeException("Error in unification algorithm.");
                    }
                    ParamFinder finder = new ParamFinder(earlyVariable);
                    searcher.initiatedSearch((ChannelTarget)ChannelSupervisor.this._netInstance, ChannelSupervisor.this._channel, new Variable((Object)arguments, null), false, (Finder)finder, (Triggerable)object);
                    2 var5_6 = this;
                    synchronized (var5_6) {
                        if (ChannelSupervisor.this._watcher != null) {
                            ChannelSupervisor.this._watcher.bindingsCalculated(finder.iterator());
                        }
                    }
                    return null;
                }
            });
            try {
                future.get();
            }
            catch (InterruptedException e) {
                _logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
            }
            catch (ExecutionException e) {
                _logger.error((Object)"Simulation thread threw an exception", (Throwable)e);
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Call to update on invalid ChannelSupervisor:" + this.toString()), new Throwable("DEBUG STACKTRACE"));
        }
    }

    private synchronized void discard() {
        if (this._watcher != null) {
            this._watcher.bindingsCalculated((Iterator<Object>)EmptyIterator.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        List<ChannelSupervisor> list = ALL_SUPERVISORS;
        synchronized (list) {
            _logger.debug((Object)"Resetting all ChannelSupervisors.");
            DIRTY_SUPERVISORS.clear();
            for (ChannelSupervisor supervisor : ALL_SUPERVISORS) {
                supervisor.discard();
            }
            ALL_SUPERVISORS.clear();
            if (_supervisorThread != null) {
                _supervisorThread.terminate();
                _supervisorThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate() {
        List<ChannelSupervisor> list = ALL_SUPERVISORS;
        synchronized (list) {
            ChannelSupervisor.reset();
            _logger.debug((Object)"Activating new ChannelSupervisor thread.");
            if (_supervisorThread == null) {
                _supervisorThread = new SupervisorThread();
                SimulationThreadPool.getCurrent().execute((Runnable)_supervisorThread);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.delayedWriteObject((Object)this._triggers, (DelayedFieldOwner)this);
            rOut.endDomain((Object)this);
        } else {
            out.writeObject(this._triggers);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._valid = false;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Deserializing " + this.toString() + "..."));
        }
        if (!(in instanceof RenewObjectInputStream)) {
            this.reassignField(in.readObject());
        }
    }

    public void reassignField(Object value) throws IOException {
        if (value instanceof TriggerCollection) {
            this._triggers = (TriggerCollection)value;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Deserialization completed:  " + this.toString()));
            }
        }
    }

    public String toString() {
        int sbSize = 1000;
        String variableSeparator = ", ";
        StringBuffer sb = new StringBuffer(1000);
        sb.append(this.getClass().getName());
        sb.append("(");
        if (this._valid) {
            sb.append("valid");
            sb.append(", ");
            sb.append("netInstance=").append(this._netInstance);
            sb.append(", ");
            sb.append("watcher=").append(this._watcher);
            sb.append(", ");
            sb.append("channel=").append(this._channel);
            sb.append(", ");
            sb.append("lateClass=").append(this._lateClass);
        } else {
            sb.append("invalid");
        }
        sb.append(", ");
        sb.append("triggers=").append(this._triggers);
        sb.append(")");
        return sb.toString();
    }

    private static class SupervisorThread
    implements Runnable {
        private boolean _active = true;

        private SupervisorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("ChannelSupervisor: Thread " + String.valueOf(Thread.currentThread()) + " started."));
            }
            while (this._active) {
                ChannelSupervisor supervisor;
                _dirtySem.P();
                if (!this._active) {
                    _dirtySem.V();
                    continue;
                }
                List<ChannelSupervisor> list = ALL_SUPERVISORS;
                synchronized (list) {
                    supervisor = DIRTY_SUPERVISORS.getFirst();
                    DIRTY_SUPERVISORS.removeFirst();
                }
                supervisor.update();
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("ChannelSupervisor: Thread " + String.valueOf(Thread.currentThread()) + " terminated."));
            }
        }

        public void terminate() {
            _logger.debug((Object)"ChannelSupervisor: Thread marked for termination.");
            this._active = false;
        }
    }
}

