/*
 * Decompiled with CFR 0.152.
 */
package de.renew.watch;

import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.application.SimulatorPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.watch.ChannelSupervisor;
import java.util.Collection;
import org.apache.log4j.Logger;

public class WatchPlugin
extends PluginAdapter {
    public static Logger _logger = Logger.getLogger(WatchPlugin.class);
    private SimulatorPlugin _simPlugin;
    private WatchExtension _watchExtension;

    public WatchPlugin(PluginProperties props) {
        super(props);
    }

    public void init() {
        PluginManager pluginManager = PluginManager.getInstance();
        Collection simPlugins = pluginManager.getPluginsProviding("de.renew.simulator");
        this._simPlugin = (SimulatorPlugin)simPlugins.iterator().next();
        this._watchExtension = new WatchExtension();
        this._simPlugin.addExtension((SimulatorExtension)this._watchExtension);
    }

    public boolean cleanup() {
        if (this._simPlugin != null && this._watchExtension != null) {
            this._simPlugin.removeExtension((SimulatorExtension)this._watchExtension);
            this._simPlugin = null;
            this._watchExtension = null;
        }
        return true;
    }

    private class WatchExtension
    extends SimulatorExtensionAdapter {
        private WatchExtension() {
        }

        public void simulationSetup(SimulationEnvironment env) {
            _logger.debug((Object)"WatchPlugin: Resetting channel supervisor.");
            ChannelSupervisor.activate();
        }

        public void simulationTerminated() {
            _logger.debug((Object)"WatchPlugin: Resetting channel supervisor.");
            ChannelSupervisor.reset();
        }
    }
}

