/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.logging.gui.RepositoryChangeListener;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceRemoveRequest;
import de.renew.logging.gui.StepTraceRepository;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractRepository
implements StepTraceRepository {
    protected Set<RepositoryChangeListener> _listeners = new HashSet<RepositoryChangeListener>();

    @Override
    public void addRepositoryChangeListener(RepositoryChangeListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeRepositoryChangeListener(RepositoryChangeListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireStepTraceChanged(StepTrace stepTrace) {
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceChanged(stepTrace);
        }
    }

    protected void fireStepTraceAdded(StepTrace stepTrace) {
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceAdded(null, stepTrace);
        }
    }

    protected void fireStepTraceRemoved(StepTrace stepTrace) {
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length; ++x) {
            l[x].stepTraceRemoved(null, stepTrace);
        }
    }

    protected boolean fireStepTraceRemoveRequest(StepTrace stepTrace) {
        boolean removeVeto = false;
        StepTraceRemoveRequest request = new StepTraceRemoveRequest(this, stepTrace);
        RepositoryChangeListener[] l = this._listeners.toArray(new RepositoryChangeListener[0]);
        for (int x = 0; x < l.length && !removeVeto; ++x) {
            l[x].stepTraceRemoveRequest(request);
            removeVeto = request.hasVeto();
        }
        return removeVeto;
    }
}

