/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import CH.ifa.draw.DrawPlugin;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.logging.gui.AppenderFactory;
import de.renew.logging.gui.ConfigureLoggingTab;
import de.renew.logging.gui.GenericAppenderEditor;
import de.renew.logging.gui.NewLoggerDialog;
import de.renew.logging.gui.TreeNodeAppenderWrapper;
import de.renew.logging.gui.TreeNodeLoggerWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertyPrinter;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.varia.NullAppender;

public class ConfigureLoggingController
implements ConfigureSimulationTabController,
TreeSelectionListener {
    private static final Logger LOGGER = Logger.getLogger(ConfigureLoggingController.class);
    private ConfigureLoggingTab _tab = new ConfigureLoggingTab(this);
    private HashMap<Appender, GenericAppenderEditor> _appenders;

    public ConfigureLoggingController() {
        this._tab.setRootNode(this.createLoggerTreeNodes());
        this._appenders = new HashMap();
    }

    public Component getTab() {
        return this._tab;
    }

    private MutableTreeNode createLoggerTreeNodes() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("defined loggers");
        Enumeration ls = LogManager.getCurrentLoggers();
        while (ls.hasMoreElements()) {
            Logger logger = (Logger)ls.nextElement();
            if (!logger.getName().startsWith("simulation")) continue;
            DefaultMutableTreeNode loggerNode = new DefaultMutableTreeNode(new TreeNodeLoggerWrapper(logger));
            boolean hasAppender = false;
            Enumeration as = logger.getAllAppenders();
            while (as.hasMoreElements()) {
                hasAppender = true;
                Appender a = (Appender)as.nextElement();
                if (a instanceof NullAppender) continue;
                DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(new TreeNodeAppenderWrapper(logger, a));
                loggerNode.add(aNode);
            }
            if (!hasAppender) continue;
            root.add(loggerNode);
        }
        return root;
    }

    public void commitTab(Properties props) {
        Enumeration ls = LogManager.getCurrentLoggers();
        while (ls.hasMoreElements()) {
            Logger logger = (Logger)ls.nextElement();
            if (!logger.getName().startsWith("simulation")) continue;
            Enumeration as = logger.getAllAppenders();
            while (as.hasMoreElements()) {
                Appender a = (Appender)as.nextElement();
                GenericAppenderEditor ae = this._appenders.get(a);
                if (ae == null) continue;
                ae.applyChanges();
                if (!(a instanceof OptionHandler)) continue;
                ((OptionHandler)a).activateOptions();
                Logger.getLogger((String)logger.getName()).addAppender(a);
            }
        }
    }

    public void updateTab(Properties props) {
        this._appenders = new HashMap();
        this.updateTab();
    }

    private void updateTab() {
        this._tab.setRootNode(this.createLoggerTreeNodes());
    }

    protected ActionListener createAddLoggerAction() {
        return new AddLoggerAction();
    }

    protected ActionListener createRemoveLoggerAction(String loggerName) {
        return new RemoveLoggerAction(loggerName);
    }

    protected ActionListener createAddAppenderAction(String loggerName, String appenderTypeName) {
        return new AddAppenderAction(loggerName, appenderTypeName);
    }

    protected ActionListener createRemoveAppenderAction(String loggerName, Appender appender) {
        return new RemoveAppenderAction(loggerName, appender);
    }

    protected ActionListener createExportConfigurationAction() {
        return new ExportConfigurationAction();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object selected = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
        if (selected instanceof TreeNodeAppenderWrapper) {
            Appender appender = ((TreeNodeAppenderWrapper)selected).getAppender();
            if (!this._appenders.containsKey(appender)) {
                this._appenders.put(appender, new GenericAppenderEditor(appender));
            }
            JScrollPane rightComponent = new JScrollPane(this._appenders.get(appender));
            rightComponent.setMinimumSize(new Dimension(300, 200));
            this._tab.setRightSide(rightComponent);
        }
    }

    private class AddLoggerAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean found = false;
            Logger logger = null;
            NewLoggerDialog newLoggerDialog = new NewLoggerDialog(this.getParentDialog());
            newLoggerDialog.setVisible(true);
            if (newLoggerDialog.isCommitted()) {
                while (!found) {
                    String loggerName = "simulation." + newLoggerDialog.getLogger();
                    logger = Logger.getLogger((String)loggerName);
                    Enumeration enumeration = logger.getAllAppenders();
                    if (enumeration.hasMoreElements()) continue;
                    found = true;
                }
            }
            if (logger != null) {
                logger.addAppender((Appender)new NullAppender());
            }
            ConfigureLoggingController.this.updateTab();
        }

        private Dialog getParentDialog() {
            Container component = ConfigureLoggingController.this._tab;
            while (!(component instanceof Dialog)) {
                component = component.getParent();
            }
            return (Dialog)component;
        }
    }

    private class RemoveLoggerAction
    implements ActionListener {
        private String _loggerName;

        public RemoveLoggerAction(String loggerName) {
            this._loggerName = loggerName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Logger logger = Logger.getLogger((String)this._loggerName);
            logger.removeAllAppenders();
            ConfigureLoggingController.this.updateTab();
        }
    }

    private class AddAppenderAction
    implements ActionListener {
        private String _loggerName;
        private String _appenderTypeName;

        public AddAppenderAction(String loggerName, String appenderTypeName) {
            this._loggerName = loggerName;
            this._appenderTypeName = appenderTypeName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Appender appender = AppenderFactory.getInstance().createNewAppender(this._appenderTypeName);
                Logger.getLogger((String)this._loggerName).addAppender(appender);
                ConfigureLoggingController.this.updateTab();
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Can't create new appender instance of appender type " + this._appenderTypeName));
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private class RemoveAppenderAction
    implements ActionListener {
        private String _loggerName;
        private Appender _appender;

        public RemoveAppenderAction(String loggerName, Appender appender) {
            this._loggerName = loggerName;
            this._appender = appender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Logger.getLogger((String)this._loggerName).removeAppender(this._appender);
            ConfigureLoggingController.this.updateTab();
        }
    }

    private class ExportConfigurationAction
    implements ActionListener {
        private ExportConfigurationAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            File propertiesOutputFile = this.promptGenerateLocation();
            if (propertiesOutputFile != null) {
                if (!propertiesOutputFile.exists()) {
                    try {
                        propertiesOutputFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    PrintWriter pw = new PrintWriter(propertiesOutputFile);
                    PropertyPrinter pp = new PropertyPrinter(pw);
                    pp.print(pw);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }

        private File promptGenerateLocation() {
            File file = new File(DrawPlugin.getCurrent().getIOHelper().getLastPath(), "/");
            JFileChooser dialog = new JFileChooser();
            dialog.setCurrentDirectory(file);
            dialog.setDialogTitle("Select a destination for the generated log4j configuration file.");
            if (dialog.showSaveDialog(DrawPlugin.getGui().getFrame()) != 0) {
                return null;
            }
            file = dialog.getSelectedFile();
            DrawPlugin.getCurrent().getIOHelper().setLastPath(file.getParentFile());
            return file;
        }
    }
}

