/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class GenericAppenderEditor
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(GenericAppenderEditor.class);
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet();
    private Appender _appender;
    private JPanel _fieldsPanel;
    private JPanel _buttonPanel;
    private Map<String, JComponent> _attributeFields = new Hashtable<String, JComponent>();
    private Map<String, Class<?>> _attributeTypes;
    private int _row = 0;

    public GenericAppenderEditor(Appender appender) {
        this._appender = appender;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this._fieldsPanel = new JPanel();
        this._fieldsPanel.setLayout(new GridBagLayout());
        this.add((Component)this._fieldsPanel, "Center");
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(new BorderLayout());
        this.add((Component)this._buttonPanel, "South");
        this._attributeTypes = this.findAttributeTypes(this._appender);
        String[] attributes = this._attributeTypes.keySet().toArray(new String[0]);
        for (int x = 0; x < attributes.length; ++x) {
            Object currentValue = this.getCurrentValue(attributes[x], this._appender);
            JComponent c = this.createComponents(attributes[x], this._attributeTypes.get(attributes[x]), currentValue);
            if (c == null) continue;
            this._attributeFields.put(attributes[x], c);
        }
    }

    private JComponent createComponents(String aName, Class<?> type, Object currentValue) {
        JComponent component = null;
        if (type == Number.class || type == Integer.TYPE || type == Long.TYPE || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Long.TYPE) {
            model = new SpinnerNumberModel();
            model.setValue(currentValue);
            component = new JSpinner(model);
            if (type == Integer.TYPE || type == Integer.class) {
                model.setMinimum(Integer.valueOf(Integer.MIN_VALUE));
                model.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
                model.setStepSize(1);
            } else if (type == Byte.TYPE || type == Byte.class) {
                model.setMinimum(Byte.valueOf((byte)-128));
                model.setMaximum(Byte.valueOf((byte)127));
                model.setStepSize(1);
            } else if (type == Long.TYPE || type == Long.class) {
                model.setMinimum(Long.valueOf(Long.MIN_VALUE));
                model.setMaximum(Long.valueOf(Long.MAX_VALUE));
                model.setStepSize(1);
            } else if (type == Float.TYPE || type == Float.class) {
                model.setMinimum(Float.valueOf(Float.MIN_VALUE));
                model.setMaximum(Float.valueOf(Float.MAX_VALUE));
            } else if (type == Double.TYPE || type == Double.class) {
                model.setMinimum(Double.valueOf(Double.MIN_VALUE));
                model.setMaximum(Double.valueOf(Double.MAX_VALUE));
            }
        } else if (type == Integer.TYPE) {
            model = new SpinnerNumberModel();
            model.setValue(currentValue);
            component = new JSpinner(model);
        } else if (String.class.isAssignableFrom(type)) {
            component = new JTextField((String)currentValue);
        } else if (Boolean.class.isAssignableFrom(type)) {
            component = new JCheckBox();
        } else if (Priority.class.isAssignableFrom(type)) {
            Priority[] levels = new Priority[]{Level.ALL, Level.INFO, Level.DEBUG, Level.ERROR, Level.FATAL, Level.OFF};
            component = new JComboBox<Priority>(levels);
            ((JComboBox)component).getModel().setSelectedItem(currentValue);
        } else if (Layout.class.isAssignableFrom(type)) {
            component = currentValue != null ? new JTextField(((PatternLayout)currentValue).getConversionPattern()) : new JTextField();
        }
        if (component != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = this._row;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 13;
            JLabel label = new JLabel(aName + ":");
            ((GridBagLayout)this._fieldsPanel.getLayout()).setConstraints(label, c);
            this._fieldsPanel.add(label);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = this._row++;
            c.weightx = 0.7;
            c.fill = 2;
            c.anchor = 17;
            c.gridwidth = 1;
            c.gridheight = 1;
            ((GridBagLayout)this._fieldsPanel.getLayout()).setConstraints(component, c);
            this._fieldsPanel.add(component);
        }
        return component;
    }

    private Map<String, Class<?>> findAttributeTypes(Appender appender) {
        Hashtable setters = new Hashtable();
        Class<?> clazz = appender.getClass();
        Method[] methods = clazz.getMethods();
        for (int x = 0; x < methods.length; ++x) {
            if (!methods[x].getName().startsWith("set") || methods[x].getParameterTypes().length != 1 || !SUPPORTED_TYPES.contains(methods[x].getParameterTypes()[0])) continue;
            String name = methods[x].getName().substring("set".length());
            setters.put(name, methods[x].getParameterTypes()[0]);
        }
        TreeMap attributeTypes = new TreeMap();
        for (int x = 0; x < methods.length; ++x) {
            String name;
            if (!methods[x].getName().startsWith("get") || !setters.containsKey(name = methods[x].getName().substring("get".length())) || methods[x].getParameterTypes().length != 0 || !SUPPORTED_TYPES.contains(methods[x].getReturnType())) continue;
            attributeTypes.put(name, methods[x].getReturnType());
        }
        return attributeTypes;
    }

    private Object getCurrentValue(String aName, Appender appender) {
        Object value = null;
        Class<?> clazz = appender.getClass();
        try {
            Method method = clazz.getMethod("get" + aName, new Class[0]);
            value = method.invoke((Object)appender, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private void setValue(Appender appender, String aName, Object value) {
        Class<?> clazz = appender.getClass();
        if (value != null) {
            Class<Object> type = value.getClass();
            if (type == Level.class) {
                type = Priority.class;
            } else if (type == PatternLayout.class) {
                type = Layout.class;
            }
            Method method = null;
            try {
                method = clazz.getMethod("set" + aName, type);
            }
            catch (NoSuchMethodException ex) {
                try {
                    if (type == Integer.class) {
                        method = clazz.getMethod("set" + aName, Integer.TYPE);
                    } else if (type == Byte.class) {
                        method = clazz.getMethod("set" + aName, Byte.TYPE);
                    } else if (type == Long.class) {
                        method = clazz.getMethod("set" + aName, Long.TYPE);
                    } else if (type == Float.class) {
                        method = clazz.getMethod("set" + aName, Float.TYPE);
                    } else if (type == Double.class) {
                        method = clazz.getMethod("set" + aName, Double.TYPE);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (method != null) {
                    value = method.invoke((Object)appender, value);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void applyChanges() {
        String[] attributes = this._attributeFields.keySet().toArray(new String[0]);
        for (int x = 0; x < attributes.length; ++x) {
            Class<?> type = this._attributeTypes.get(attributes[x]);
            JComponent c = this._attributeFields.get(attributes[x]);
            if (type == null || c == null) continue;
            if (c instanceof JTextField) {
                String text = ((JTextField)c).getText();
                if (attributes[x].equals("Layout")) {
                    this.setValue(this._appender, attributes[x], new PatternLayout(text));
                    continue;
                }
                this.setValue(this._appender, attributes[x], text);
                continue;
            }
            if (c instanceof JSpinner) {
                SpinnerModel model = ((JSpinner)c).getModel();
                this.setValue(this._appender, attributes[x], model.getValue());
                continue;
            }
            if (c instanceof JCheckBox) {
                this.setValue(this._appender, attributes[x], ((JCheckBox)c).isSelected());
                continue;
            }
            if (!(c instanceof JComboBox)) continue;
            this.setValue(this._appender, attributes[x], ((JComboBox)c).getModel().getSelectedItem());
        }
    }

    static {
        SUPPORTED_TYPES.add(Integer.class);
        SUPPORTED_TYPES.add(Long.class);
        SUPPORTED_TYPES.add(Float.class);
        SUPPORTED_TYPES.add(Double.class);
        SUPPORTED_TYPES.add(Boolean.class);
        SUPPORTED_TYPES.add(String.class);
        SUPPORTED_TYPES.add(Byte.class);
        SUPPORTED_TYPES.add(Integer.TYPE);
        SUPPORTED_TYPES.add(Long.TYPE);
        SUPPORTED_TYPES.add(Float.TYPE);
        SUPPORTED_TYPES.add(Double.TYPE);
        SUPPORTED_TYPES.add(Boolean.TYPE);
        SUPPORTED_TYPES.add(Byte.TYPE);
        SUPPORTED_TYPES.add(Priority.class);
        SUPPORTED_TYPES.add(Layout.class);
    }
}

