/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.GuiPlugin;
import de.renew.gui.ModeReplacement;
import de.renew.logging.gui.ConfigureLoggingController;
import de.renew.logging.gui.GuiAppender;
import de.renew.logging.gui.LoggingController;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;
import de.renew.windowmanagement.Workbench;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenuItem;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class LoggingGuiPlugin
extends DIPlugin {
    private static final Logger LOGGER = Logger.getLogger(LoggingGuiPlugin.class);
    private static final Set<LoggingController> LOGGING_FRAME_CONTROLLERS = new HashSet<LoggingController>();
    private CommandMenuItem _menu;
    private ConfigureLoggingController _configTab;
    private final Workbench _workbench;

    @Inject
    public LoggingGuiPlugin(Workbench workbench) {
        this._workbench = workbench;
    }

    public void init() {
        LOGGER.debug((Object)"initializing Logging GUI plugin.");
        this._configTab = new ConfigureLoggingController();
        GuiPlugin.getCurrent().addConfigTabController((ConfigureSimulationTabController)this._configTab);
        this._menu = new CommandMenuItem(new Command("show simulation trace"){

            public boolean isExecutable() {
                if (!super.isExecutable()) {
                    return false;
                }
                return ModeReplacement.getInstance().getSimulation().isSimulationActive();
            }

            public void execute() {
                new LoggingController(LOGGING_FRAME_CONTROLLERS, LoggingGuiPlugin.this._workbench);
            }
        }, 76);
        MenuManager mm = MenuManager.getInstance();
        MenuManager.SeparatorFactory sepFac = new MenuManager.SeparatorFactory("de.renew.logging.gui");
        mm.registerMenu("Simulation", sepFac.createSeparator());
        mm.registerMenu("Simulation", (JMenuItem)this._menu, "de.renew.logging.gui.showTrace");
        Logger.getLogger((String)"simulation").addAppender((Appender)new GuiAppender());
    }

    public static LoggingGuiPlugin getCurrent() {
        for (IPlugin o : PluginManager.getInstance().getPluginsProviding("de.renew.logging.gui")) {
            if (!(o instanceof LoggingGuiPlugin)) continue;
            return (LoggingGuiPlugin)o;
        }
        return null;
    }

    public boolean cleanup() {
        for (LoggingController c : LOGGING_FRAME_CONTROLLERS) {
            c.closeFrame();
        }
        DrawPlugin.getCurrent().getMenuManager().unregisterMenu((JMenuItem)this._menu);
        GuiPlugin.getCurrent().removeConfigTabController((ConfigureSimulationTabController)this._configTab);
        return true;
    }

    public void closedLoggingFrame(LoggingController controller) {
        LOGGING_FRAME_CONTROLLERS.remove(controller);
    }
}

