/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.ant;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractExportTask
extends Task {
    private final ExportFormat _exportFormat;
    private final String _defaultExtension;
    private File _destdir = null;
    private Vector<FileSet> _filesets = new Vector();

    protected AbstractExportTask(ExportFormat exportFormat) {
        this._exportFormat = exportFormat;
        FileFilter fileFilter = exportFormat.fileFilter();
        this._defaultExtension = fileFilter instanceof SimpleFileFilter ? ((SimpleFileFilter)fileFilter).getExtension() : exportFormat.formatName();
    }

    public void setDestdir(File dest) {
        this._destdir = dest;
    }

    public void execute() throws BuildException {
        super.execute();
        Logger logger = Logger.getLogger((String)"CH.ifa.draw");
        logger.setLevel(Level.INFO);
        logger = Logger.getLogger((String)"de.renew");
        logger.setLevel(Level.INFO);
        for (FileSet elementFileSet : this._filesets) {
            DirectoryScanner dirScan = elementFileSet.getDirectoryScanner(this.getProject());
            String[] fileNames = dirScan.getIncludedFiles();
            this.log("filenames: " + fileNames.length, 3);
            for (int i = 0; i < fileNames.length; ++i) {
                String fileName = fileNames[i];
                File inFile = new File(String.valueOf(dirScan.getBasedir()) + "/" + fileName);
                this.log("File: " + inFile.getAbsolutePath(), 3);
                Drawing netDrawing = DrawingFileHelper.loadDrawing((File)inFile, (StatusDisplayer)new StatusDisplayer(){

                    public void showStatus(String message) {
                        AbstractExportTask.this.log(message);
                    }
                });
                this.log("Drawing: " + String.valueOf(netDrawing), 3);
                if (netDrawing == null) {
                    throw new BuildException("Could not read drawing file: " + String.valueOf(inFile));
                }
                try {
                    File helpFile = new File(String.valueOf(this._destdir) + "/" + fileName);
                    File outFile = new File(helpFile.getParent() + "/" + netDrawing.getName() + "." + this._defaultExtension);
                    outFile.getParentFile().mkdirs();
                    this._exportFormat.export(netDrawing, outFile);
                    continue;
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    public void addFileset(FileSet fileset) {
        this._filesets.add(fileset);
    }
}

