/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import java.awt.Dimension;
import java.awt.Rectangle;

public class AnnealingGraphLayout {
    public final double springLength = 1.0;
    public final double springStrength = 0.05;
    public final double repulsionDistance = 400.0;
    public final double repulsionStrength = 2.0;
    public final double torqueStrength = 0.25;
    public final double friction = 0.25;
    public final int layoutOffset = 65536;
    public final int steps = 2048;

    public GraphLayout annealingLayout(LayoutableDrawing drawing) {
        GraphLayout layout = new GraphLayout();
        drawing.fillInGraph(layout);
        this.randomInit(layout, drawing.defaultSize());
        this.anneal(layout);
        int overOffset = 131072;
        layout.moveBy(-overOffset, -overOffset);
        Rectangle box = drawing.displayBox();
        layout.moveBy(-box.x, -box.y);
        drawing.figureRequestUpdate(null);
        return layout;
    }

    private void randomInit(GraphLayout layout, Dimension windowSize) {
        layout.randomInit(65536.0, 65536.0, windowSize.width, windowSize.height);
    }

    private void anneal(GraphLayout layout) {
        layout.lengthFactor = 1.0;
        layout.repulsionLimit = 400.0;
        layout.torqueStrength = 0.25;
        for (int i = 0; i < 2048; ++i) {
            double progress = (double)i / 2048.0;
            double annealingFactor = 1.0 + (1.0 - progress) * 10.0;
            layout.springStrength = annealingFactor * 0.05;
            layout.repulsionStrength = annealingFactor * 2.0;
            layout.frictionFactor = 1.0 - progress * 0.25;
            layout.relax();
        }
    }
}

