/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class CircleDecoration
implements LineDecoration {
    private static final long serialVersionUID = -3459870923049638L;
    private final double fRadius;
    private final boolean fFilled;
    private final int circleDecorationSerializedDataVersion = 1;

    public CircleDecoration() {
        this(4, true);
    }

    public CircleDecoration(int radius) {
        this(radius, true);
    }

    public CircleDecoration(boolean filled) {
        this(4, filled);
    }

    public CircleDecoration(int radius, boolean filled) {
        this.fRadius = radius;
        this.fFilled = filled;
    }

    public void draw(Graphics g, int x1, int y1, int x2, int y2, Color fillColor, Color lineColor) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double rr = dx * dx + dy * dy;
        if (rr != 0.0) {
            double r = Math.sqrt(rr);
            x1 += (int)(dx * this.fRadius / r);
            y1 += (int)(dy * this.fRadius / r);
        }
        if (this.fFilled) {
            fillColor = lineColor;
        }
        if (!ColorMap.isTransparent((Color)fillColor)) {
            g.setColor(fillColor);
            g.fillOval((int)((double)x1 - this.fRadius), (int)((double)y1 - this.fRadius), (int)(2.0 * this.fRadius), (int)(2.0 * this.fRadius));
        }
        if (!this.fFilled && !ColorMap.isTransparent((Color)lineColor)) {
            g.setColor(lineColor);
            g.drawOval((int)((double)x1 - this.fRadius), (int)((double)y1 - this.fRadius), (int)(2.0 * this.fRadius), (int)(2.0 * this.fRadius));
        }
    }

    public void write(StorableOutput dw) {
    }

    public void read(StorableInput dr) throws IOException {
    }
}

