/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.ant;

import CH.ifa.draw.standard.FigureException;
import de.renew.ant.AntTaskLogAppender;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.ShadowTranslator;
import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.SyntaxException;
import de.renew.util.ClassSource;
import de.renew.util.StringUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class CreateShadownetsTask
extends Task {
    private String compilerName = null;
    private boolean timed = false;
    private File destdir = null;
    private File destfile = null;
    private final Vector<FileSet> filesets = new Vector();
    private boolean compile = false;
    private boolean oneSystem = false;
    private Path classpath = null;
    private Path netpath = null;

    public void setDestdir(File dest) {
        this.destdir = dest;
    }

    public void setCompilerName(String compilerName) {
        this.compilerName = compilerName;
    }

    public void setTimed(boolean timed) {
        this.timed = timed;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public void setOneSystem(boolean oneSystem) {
        this.oneSystem = oneSystem;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void addConfiguredFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setClasspath(Path classpath) {
        if (this.classpath != null) {
            throw new BuildException("Duplicate classpath definition.");
        }
        this.classpath = classpath;
    }

    public void setClasspathref(Reference classpathref) {
        if (this.classpath != null) {
            throw new BuildException("Duplicate classpath definition.");
        }
        this.classpath = (Path)classpathref.getReferencedObject(this.getProject());
    }

    public void setNetpathref(Reference netpath) {
        this.netpath = (Path)netpath.getReferencedObject(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.destfile != null && this.destdir != null) {
            throw new BuildException("Cannot specify both the destfile and destdir attributes.");
        }
        if (this.destfile == null && this.destdir == null) {
            throw new BuildException("Must specify one of destfile or destdir attributes.");
        }
        String graphicStatus = System.setProperty("de.renew.noGraphics", "true");
        try {
            Logger logger = Logger.getLogger((String)"CH.ifa.draw");
            AntTaskLogAppender appender = AntTaskLogAppender.getInstance((Task)this);
            logger.addAppender((Appender)appender);
            logger.setLevel(Level.INFO);
            logger = Logger.getLogger((String)"de.renew");
            logger.addAppender((Appender)appender);
            logger.setLevel(Level.INFO);
            SourceFileScanner sfscanner = new SourceFileScanner((Task)this);
            MergingMapper mapper = null;
            boolean needAllNets = true;
            if (this.destfile != null) {
                MergingMapper mmapper = new MergingMapper();
                mmapper.setTo(this.destfile.getPath());
                mapper = mmapper;
                needAllNets = true;
            } else if (this.destdir != null) {
                GlobPatternMapper gpmapper = new GlobPatternMapper();
                gpmapper.setFrom("*.rnw");
                gpmapper.setTo(String.valueOf(this.destdir) + File.separator + "*.sns");
                mapper = gpmapper;
                needAllNets = false;
            }
            assert (mapper != null) : "No mapper configured.";
            CPNDrawing[] drawings = null;
            File[] destsnsfiles = null;
            HashSet<String> uptodateNetLocations = new HashSet<String>();
            Enumeration<FileSet> enumeration = this.filesets.elements();
            while (enumeration.hasMoreElements()) {
                int offset;
                FileSet fs = enumeration.nextElement();
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File dir = ds.getBasedir();
                String[] nets = ds.getIncludedFiles();
                if (!needAllNets) {
                    String[] newnets = sfscanner.restrict(nets, dir, this.destdir, (FileNameMapper)mapper);
                    int j = 0;
                    String[] stringArray = nets;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String[] snsfiles;
                        String net = stringArray[i];
                        if (j < newnets.length && net.equals(newnets[j])) {
                            ++j;
                            continue;
                        }
                        for (String snsfile : snsfiles = mapper.mapFileName(net)) {
                            String loc = StringUtil.convertToSystem((String)StringUtil.getPath((String)StringUtil.convertToSlashes((String)snsfile)));
                            if (!uptodateNetLocations.add(loc)) continue;
                            this.log("Added " + loc + " to net loader (from " + snsfile + ").", 3);
                        }
                    }
                    assert (j == newnets.length) : "Loop has holes!? (" + j + "!=" + newnets.length + ")";
                    nets = newnets;
                }
                File[] netfiles = new File[nets.length];
                int n = nets.length;
                for (int i = 0; i < n; ++i) {
                    netfiles[i] = new File(dir, nets[i]);
                }
                CPNDrawing[] newDrawings = ShadowTranslator.readDrawings(netfiles);
                if (newDrawings != null) {
                    if (drawings == null) {
                        drawings = newDrawings;
                    } else {
                        CPNDrawing[] mergedDrawings = new CPNDrawing[drawings.length + newDrawings.length];
                        System.arraycopy(drawings, 0, mergedDrawings, 0, drawings.length);
                        System.arraycopy(newDrawings, 0, mergedDrawings, drawings.length, newDrawings.length);
                        drawings = mergedDrawings;
                    }
                }
                if (this.destdir == null) continue;
                if (destsnsfiles == null) {
                    destsnsfiles = new File[nets.length];
                    offset = 0;
                } else {
                    File[] enlargedArray = new File[destsnsfiles.length + nets.length];
                    System.arraycopy(destsnsfiles, 0, enlargedArray, 0, destsnsfiles.length);
                    offset = destsnsfiles.length;
                    destsnsfiles = enlargedArray;
                }
                for (int i = 0; i < nets.length; ++i) {
                    String[] destination = mapper.mapFileName(nets[i]);
                    destsnsfiles[offset + i] = new File(destination[0]);
                    this.log("Create parent directory.", 4);
                    File parentDir = destsnsfiles[offset + i].getParentFile();
                    this.log("parentDir = " + String.valueOf(parentDir), 4);
                    if (parentDir != null) {
                        Mkdir mkdir = new Mkdir();
                        mkdir.setDir(parentDir);
                        try {
                            mkdir.execute();
                        }
                        catch (NullPointerException e) {
                            this.log("Mkdir throws exception, was probably successful anyway: ", 4);
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.log("No parent directory for destination file " + String.valueOf(destsnsfiles[offset + i]), 1);
                }
            }
            if (drawings == null) {
                throw new BuildException("No drawings specified.");
            }
            if (this.classpath != null) {
                ClassSource.setClassLoader((ClassLoader)new AntClassLoader(CreateShadownetsTask.class.getClassLoader(), this.getProject(), this.classpath, true));
            }
            ShadowCompilerFactory factory = this.getShadowCompiler();
            if (this.compile) {
                if (factory == null) {
                    throw new BuildException("Cannot compile - no valid compiler name configured: " + this.compilerName);
                }
                this.log("Using compiler " + String.valueOf(factory), 3);
                if (this.classpath == null) {
                    throw new BuildException("Cannot compile - no class path configured.");
                }
                this.log("Using classpath " + String.valueOf(this.classpath), 4);
            }
            if (this.oneSystem && this.destfile == null) {
                throw new BuildException("Cannot create shadow net system - no destfile configured.");
            }
            Properties props = new Properties();
            boolean first = true;
            if (!needAllNets) {
                StringBuilder netpath = new StringBuilder();
                for (String uptodateNetLocation : uptodateNetLocations) {
                    if (first) {
                        first = false;
                    } else {
                        netpath.append(File.pathSeparator);
                    }
                    netpath.append(uptodateNetLocation);
                }
                props.setProperty("de.renew.netPath", netpath.toString());
            }
            if (this.netpath != null) {
                String[] liste;
                StringBuilder netPath = new StringBuilder(props.getProperty("de.renew.netPath", ""));
                for (String s : liste = this.netpath.list()) {
                    if (first) {
                        first = false;
                    } else {
                        netPath.append(File.pathSeparator);
                    }
                    netPath.append(s);
                }
                props.setProperty("de.renew.netPath", netPath.toString());
            }
            DefaultShadowNetLoader netloader = new DefaultShadowNetLoader(props);
            try {
                if (this.oneSystem) {
                    ShadowTranslator.writeSingleShadow(factory, this.compile, drawings, this.destfile);
                } else {
                    ShadowTranslator.writeShadows(factory, this.compile, drawings, destsnsfiles, (ShadowNetLoader)netloader);
                }
            }
            catch (SyntaxException e) {
                BuildException toThrow;
                try {
                    FigureException figEx = FigureExceptionFactory.createFigureException(e);
                    System.out.println("CreateShadownetsTask.execute : " + String.valueOf(figEx.errorDrawing.getFilename()));
                    Location location = new Location(figEx.errorDrawing.getFilename().toString(), figEx.line, figEx.column);
                    toThrow = new BuildException("Net Compilation " + figEx.getMessage(), (Throwable)e, location);
                }
                catch (Exception ignoredEx) {
                    System.out.println("CreateShadownetsTask.execute : ");
                    toThrow = new BuildException((Throwable)e);
                }
                throw toThrow;
            }
        }
        finally {
            if (graphicStatus != null) {
                System.setProperty("de.renew.noGraphics", graphicStatus);
            } else {
                System.clearProperty("de.renew.noGraphics");
            }
        }
    }

    private ShadowCompilerFactory getShadowCompiler() {
        if (this.compilerName == null) {
            return null;
        }
        try {
            if (this.timed) {
                Class c = ClassSource.classForName((String)this.compilerName);
                Constructor constructor = c.getConstructor(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                return (ShadowCompilerFactory)constructor.newInstance(true, true, true);
            }
            Class c = ClassSource.classForName((String)this.compilerName);
            return (ShadowCompilerFactory)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.log("Could not create ShadowNetCompiler. Reason:\n" + String.valueOf(e));
            return null;
        }
    }
}

