/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.configure.ConfigureNetpathTab;
import de.renew.gui.configure.EditPathEntryDialog;
import de.renew.gui.configure.NetpathModel;
import de.renew.util.PathEntry;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.ListSelectionModel;
import org.apache.log4j.Logger;

public class ConfigureNetpathController
implements ConfigureSimulationTabController {
    private static final Logger logger = Logger.getLogger(ConfigureNetpathController.class);
    private final ConfigureNetpathTab tab = new ConfigureNetpathTab();
    private NetpathModel model = null;

    public ConfigureNetpathController() {
        this.tab.addAddEntryListener(e -> this.addEntry());
        this.tab.addEditEntryListener(e -> this.editEntry());
        this.tab.addRemoveEntryListener(e -> this.removeEntry());
        this.tab.addDownEntryListener(e -> this.downEntry());
        this.tab.addUpEntryListener(e -> this.upEntry());
    }

    @Override
    public Component getTab() {
        return this.tab;
    }

    @Override
    public void commitTab(Properties props) {
        if (this.model != null) {
            String newPath = this.model.asPath();
            props.setProperty("de.renew.netPath", newPath);
            logger.debug((Object)("ConfigureNetpathController: Configured netpath=" + newPath + "."));
        }
    }

    @Override
    public void updateTab(Properties props) {
        this.model = new NetpathModel(props.getProperty("de.renew.netPath", System.getProperty("user.dir")));
        this.tab.setPathList(this.model);
    }

    public void addEntry() {
        EditPathEntryDialog dialog = new EditPathEntryDialog(this.getParentDialog(), "Add");
        dialog.setEntry(new PathEntry("", false));
        dialog.setVisible(true);
        if (dialog.isCommitted()) {
            PathEntry newEntry = dialog.getEntry();
            int insertionPoint = this.tab.getSelection().getMinSelectionIndex();
            if (insertionPoint == -1) {
                this.model.add(newEntry);
            } else {
                this.model.add(insertionPoint, newEntry);
            }
        }
    }

    public void editEntry() {
        ListSelectionModel selection = this.tab.getSelection();
        for (int index = selection.getMinSelectionIndex(); index <= selection.getMaxSelectionIndex(); ++index) {
            if (!selection.isSelectedIndex(index)) continue;
            EditPathEntryDialog dialog = new EditPathEntryDialog(this.getParentDialog(), "Change");
            dialog.setEntry(this.model.get(index));
            dialog.setVisible(true);
            if (!dialog.isCommitted()) continue;
            this.model.set(index, dialog.getEntry());
        }
    }

    public void upEntry() {
        ListSelectionModel selection = this.tab.getSelection();
        int insertionIndex = selection.getMinSelectionIndex() - 1;
        if (insertionIndex < 0) {
            insertionIndex = 0;
        }
        int[] indices = this.computeSelectedIndices(selection);
        PathEntry[] toMove = this.model.removeAll(indices);
        this.model.addAll(insertionIndex, toMove);
        selection.addSelectionInterval(insertionIndex, insertionIndex + toMove.length - 1);
    }

    public void downEntry() {
        ListSelectionModel selection = this.tab.getSelection();
        int insertionIndex = selection.getMaxSelectionIndex() + 1;
        int[] indices = this.computeSelectedIndices(selection);
        PathEntry[] toMove = this.model.removeAll(indices);
        if ((insertionIndex = insertionIndex - toMove.length + 1) > this.model.getSize()) {
            insertionIndex = this.model.getSize();
        }
        this.model.addAll(insertionIndex, toMove);
        selection.addSelectionInterval(insertionIndex, insertionIndex + toMove.length - 1);
    }

    public void removeEntry() {
        this.model.removeAll(this.computeSelectedIndices(this.tab.getSelection()));
    }

    private int[] computeSelectedIndices(ListSelectionModel selection) {
        int maxCount = selection.getMaxSelectionIndex() - selection.getMinSelectionIndex() + 1;
        int[] indices = new int[maxCount];
        int count = 0;
        for (int index = selection.getMinSelectionIndex(); index <= selection.getMaxSelectionIndex(); ++index) {
            if (!selection.isSelectedIndex(index)) continue;
            indices[count] = index;
            ++count;
        }
        if (count < maxCount) {
            int[] shortenedIndices = new int[count];
            System.arraycopy(indices, 0, shortenedIndices, 0, count);
            indices = shortenedIndices;
        }
        return indices;
    }

    private JDialog getParentDialog() {
        Container component = this.tab;
        while (!(component instanceof JDialog)) {
            component = component.getParent();
        }
        return (JDialog)component;
    }
}

