/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

class NetpathModel
extends AbstractListModel<String> {
    private final List<PathEntry> paths;

    NetpathModel(String netpath) {
        PathEntry[] entries = StringUtil.canonizePaths((String[])StringUtil.splitPaths((String)netpath));
        this.paths = new ArrayList<PathEntry>(entries.length + 5);
        Collections.addAll(this.paths, entries);
    }

    String asPath() {
        return DefaultShadowNetLoader.asPathString((PathEntry[])this.paths.toArray(new PathEntry[0]));
    }

    @Override
    public int getSize() {
        return this.paths.size();
    }

    @Override
    public String getElementAt(int n) {
        PathEntry entry = this.paths.get(n);
        StringBuilder buffer = new StringBuilder();
        if (entry.isClasspathRelative) {
            buffer.append("CLASSPATH");
            if (!"".equals(entry.path)) {
                buffer.append(File.separator);
            }
        }
        buffer.append(entry.path);
        return buffer.toString();
    }

    void add(int index, PathEntry entry) {
        this.paths.add(index, entry);
        this.fireIntervalAdded(this, index, index);
    }

    void add(PathEntry entry) {
        int lastindex = this.paths.size();
        this.add(lastindex, entry);
    }

    void set(int index, PathEntry entry) {
        this.paths.remove(index);
        this.paths.add(index, entry);
        this.fireContentsChanged(this, index, index);
    }

    PathEntry get(int index) {
        return this.paths.get(index);
    }

    PathEntry remove(int index) {
        PathEntry removed = this.paths.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return removed;
    }

    PathEntry[] removeAll(int[] indices) {
        if (indices == null || indices.length == 0) {
            return new PathEntry[0];
        }
        ArrayList<PathEntry> removed = new ArrayList<PathEntry>(this.paths.size());
        for (int index : indices) {
            removed.add(this.paths.get(index));
        }
        int firstConsecutiveIndex = indices[indices.length - 1];
        int lastRemovedIndex = indices[indices.length - 1] + 1;
        for (int i = indices.length - 1; i >= 0; --i) {
            this.paths.remove(indices[i]);
            if (indices[i] != lastRemovedIndex - 1) {
                this.fireIntervalRemoved(this, lastRemovedIndex, firstConsecutiveIndex);
                firstConsecutiveIndex = indices[i];
            }
            lastRemovedIndex = indices[i];
        }
        this.fireIntervalRemoved(this, lastRemovedIndex, firstConsecutiveIndex);
        return removed.toArray(new PathEntry[0]);
    }

    void addAll(int index, PathEntry[] entries) {
        this.paths.addAll(index, Arrays.asList(entries));
        this.fireIntervalAdded(this, index, index + entries.length - 1);
    }
}

