/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.GraphicParser;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AnnotationParser
extends ElementParser {
    private static final Logger logger = Logger.getLogger(AnnotationParser.class);
    private String _text;
    private int _offSetX = 0;
    private int _offSetY = 0;

    public AnnotationParser(Element annotation, NetConverter converter) {
        super(annotation, converter);
    }

    @Override
    protected void doParse() {
        NodeList texte = this.getElement().getElementsByTagName("text");
        if (texte.getLength() == 0) {
            texte = this.getElement().getElementsByTagName("value");
        }
        for (int pos = 0; pos < texte.getLength(); ++pos) {
            Element textEle = (Element)texte.item(pos);
            Text text = (Text)textEle.getFirstChild();
            if (text == null) continue;
            this._text = text.getData();
        }
        NodeList graphics = this.getElement().getElementsByTagName("graphics");
        for (int pos = 0; pos < graphics.getLength(); ++pos) {
            Element graphic = (Element)graphics.item(pos);
            GraphicParser parser = new GraphicParser(graphic, this.getNetConverter());
            parser.parse();
            this._offSetX = parser.offsetX();
            this._offSetY = parser.offsetY();
        }
    }

    public TextFigure getFigure() {
        NetConverter con = this.getNetConverter();
        TextFigure textFig = con.convertAnnotationToTextFigure(this.getElement());
        if (this._text == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(AnnotationParser.class.getSimpleName() + ": PMNL text figure without text ignored: " + textFig.getClass().getSimpleName()));
            }
            return null;
        }
        textFig.setText(this._text);
        textFig.moveBy(this._offSetX, this._offSetY);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(AnnotationParser.class.getSimpleName() + ": PMNL text figure detected: " + textFig.getClass().getSimpleName() + " " + textFig.getText()));
        }
        return textFig;
    }
}

