/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.Suggestion;
import de.renew.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class MethodSuggestion
extends Suggestion {
    public static final Logger LOGGER = Logger.getLogger(MethodSuggestion.class);
    private final Class[] _types;
    private final Method _method;
    private final String[] _parameters;
    private final String _callWithParameters;
    private final String _attemptedMethod;

    public static List<MethodSuggestion> suggest(Class<?> clazz, String name, Class<?>[] types, int modifier) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(JavaHelper.class.getName() + ": Class = " + clazz.toString()));
        }
        ArrayList<Method> resultMethodList = new ArrayList<Method>();
        Method[] methods = clazz.getMethods();
        if (methods.length != 0) {
            String methodPattern = name;
            boolean filter = false;
            if (methodPattern.endsWith("_")) {
                methodPattern = methodPattern.substring(0, methodPattern.length() - 1);
                filter = true;
            }
            if (methods.length > 20) {
                filter = true;
            }
            if (name.equals("_")) {
                filter = false;
            }
            for (Method method : methods) {
                int mod = method.getModifiers();
                String methodName = method.getName();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Name " + methodName + " pattern: " + methodPattern));
                    LOGGER.debug((Object)(JavaHelper.class.getName() + ": modifier for " + method.getName() + "= " + mod + " " + !filter + methodName.startsWith(methodPattern)));
                }
                if (filter && !methodName.startsWith(methodPattern)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(JavaHelper.class.getName() + ": passed filter " + ((modifier & mod) != 0)));
                }
                if ((modifier & mod) == 0) continue;
                resultMethodList.add(method);
            }
        }
        ArrayList<MethodSuggestion> result = new ArrayList<MethodSuggestion>();
        for (Method method : resultMethodList) {
            result.add(new MethodSuggestion(method, types, name));
        }
        Collections.sort(result);
        return result;
    }

    public MethodSuggestion(Method method, Class[] types, String attemptedMethod) {
        super(method.getName(), method.getReturnType().getSimpleName());
        this._method = method;
        this._types = types;
        this._attemptedMethod = attemptedMethod;
        Class<?>[] parameterTypes = method.getParameterTypes();
        this._parameters = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this._parameters[i] = parameterTypes[i].getSimpleName();
        }
        this._callWithParameters = this._name + "(" + StringUtil.join((String[])this._parameters, (String)", ") + ")";
    }

    @Override
    public String toString() {
        return "<html>" + this.getCallWithParameters() + " : " + this.getTypeName() + " <font color=gray>- " + this._method.getDeclaringClass().getSimpleName() + "</font></html>";
    }

    public String getCallWithParameters() {
        return this._callWithParameters;
    }

    public Method getMethod() {
        return this._method;
    }

    public Class<?>[] getAttemptedTypes() {
        return this._types;
    }

    public String[] getParameters() {
        return this._parameters;
    }

    public String getAttemptedMethod() {
        return this._attemptedMethod;
    }
}

