/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.jfiglet.core;

public class FIGFontLayout {
    public static final int HORIZONTAL_LAYOUT_MODE_FULL_SIZE = 0;
    public static final int HORIZONTAL_LAYOUT_MODE_FITTING_ONLY = 1;
    public static final int HORIZONTAL_LAYOUT_MODE_SMUSHING = 2;
    public static final int VERTICAL_LAYOUT_MODE_FULL_SIZE = 3;
    public static final int VERTICAL_LAYOUT_MODE_FITTING_ONLY = 4;
    public static final int VERTICAL_LAYOUT_MODE_SMUSHING = 5;
    private static final int OLD_LAYOUT_FULL_WIDTH = -1;
    private static final int OLD_LAYOUT_HORIZONTAL_FITTING = 0;
    private static final int FULL_LAYOUT_HORIZONTAL_FITTING = 64;
    private static final int FULL_LAYOUT_HORIZONTAL_SMUSHING = 128;
    private static final int FULL_LAYOUT_VERTICAL_FITTING = 8192;
    private static final int FULL_LAYOUT_VERTICAL_SMUSHING = 16384;
    private static final int SMUSHING_RULE_UNIVERSAL = 0;
    public static final int HORIZONTAL_SMUSHING_RULE_EQUALS_CHARACTER = 1;
    public static final int HORIZONTAL_SMUSHING_RULE_UNDERSCORE = 2;
    public static final int HORIZONTAL_SMUSHING_RULE_HIERARCHY = 4;
    public static final int HORIZONTAL_SMUSHING_RULE_OPPOSITE_PAIR = 8;
    public static final int HORIZONTAL_SMUSHING_RULE_BIG_X = 16;
    public static final int HORIZONTAL_SMUSHING_RULE_HARDBLANK = 32;
    public static final int VERTICAL_SMUSHING_RULE_EQUALS_CHARACTER = 256;
    public static final int VERTICAL_SMUSHING_RULE_UNDERSCORE = 512;
    public static final int VERTICAL_SMUSHING_RULE_HIERARCHY = 1024;
    public static final int VERTICAL_SMUSHING_RULE_HORIZONTAL_LINE = 2048;
    public static final int VERTICAL_SMUSHING_RULE_VERTICAL_LINE = 4096;
    private int horizontalMode = 1;
    private int verticalMode = 3;
    private int horizontalSmushingModes = 0;
    private int verticalSmushingModes = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FIGFontLayout(int theOldLayoutSpecification, Integer theFullLayoutSpecification) {
        if (theOldLayoutSpecification < -1 || theOldLayoutSpecification > 63) {
            throw new IllegalArgumentException("the old layout specification must be an integer between -1 and 63 included");
        }
        if (theFullLayoutSpecification != null && (theFullLayoutSpecification < 0 || theFullLayoutSpecification > Short.MAX_VALUE)) {
            throw new IllegalArgumentException("the full layout specification must be an integer between 0 and 32767 included");
        }
        if (theOldLayoutSpecification == -1) {
            this.horizontalMode = 0;
            if (theFullLayoutSpecification != null && ((theFullLayoutSpecification & 0x40) == 64 || (theFullLayoutSpecification & 0x80) == 128)) {
                throw new IllegalArgumentException("Old and full layout specifications are unconsistent");
            }
        } else if (theOldLayoutSpecification == 0) {
            if (theFullLayoutSpecification != null) {
                if ((theFullLayoutSpecification & 0x40) == 64 && (theFullLayoutSpecification & 0x80) == 0) {
                    this.horizontalMode = 1;
                } else {
                    if ((theFullLayoutSpecification & 0x40) != 0 || (theFullLayoutSpecification & 0x80) != 128) throw new IllegalArgumentException("The old and full layout specifications are unconsistent");
                    this.horizontalMode = 2;
                }
            } else {
                this.horizontalMode = 1;
            }
        } else {
            this.horizontalMode = 2;
            this.horizontalSmushingModes = theOldLayoutSpecification;
        }
        if (theFullLayoutSpecification == null) return;
        if ((theFullLayoutSpecification & 0x2000) == 8192) {
            this.verticalMode = 4;
            return;
        } else {
            if ((theFullLayoutSpecification & 0x4000) != 16384) return;
            this.verticalMode = 5;
            this.verticalSmushingModes = theFullLayoutSpecification;
        }
    }

    public int getHorizontalMode() {
        return this.horizontalMode;
    }

    public int getVerticalMode() {
        return this.verticalMode;
    }

    public boolean hasHorizontalSmushingRule(int theSmushingRule) {
        return (this.horizontalSmushingModes & theSmushingRule) == theSmushingRule;
    }

    public boolean hasVerticalSmushingRule(int theSmushingRule) {
        return (this.verticalSmushingModes & theSmushingRule) == theSmushingRule;
    }
}

