/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ConcurrentModificationException;

public class FRLayout2<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    private double forceConstant;
    private double temperature;
    private int currentIteration;
    private int maxIterations = 700;
    protected LoadingCache<V, Point2D> frVertexData = CacheBuilder.newBuilder().build(new CacheLoader<V, Point2D>(){

        @Override
        public Point2D load(V vertex) {
            return new Point2D.Double();
        }
    });
    private double attraction_multiplier = 0.75;
    private double attraction_constant;
    private double repulsion_multiplier = 0.75;
    private double repulsion_constant;
    private double max_dimension;
    private Rectangle2D innerBounds = new Rectangle2D.Double();
    private boolean checked = false;
    private double EPSILON = 1.0E-6;

    public FRLayout2(Graph<V, E> g2) {
        super(g2);
    }

    public FRLayout2(Graph<V, E> g2, Dimension d) {
        super(g2, new RandomLocationTransformer(d), d);
        this.max_dimension = Math.max(d.height, d.width);
        this.initialize();
    }

    @Override
    public void setSize(Dimension size) {
        if (!this.initialized) {
            this.setInitializer(new RandomLocationTransformer(size));
        }
        super.setSize(size);
        double t = (double)size.width / 50.0;
        this.innerBounds.setFrameFromDiagonal(t, t, (double)size.width - t, (double)size.height - t);
        this.max_dimension = Math.max(size.height, size.width);
    }

    public void setAttractionMultiplier(double attraction) {
        this.attraction_multiplier = attraction;
    }

    public void setRepulsionMultiplier(double repulsion) {
        this.repulsion_multiplier = repulsion;
    }

    @Override
    public void reset() {
        this.doInit();
    }

    @Override
    public void initialize() {
        this.doInit();
    }

    private void doInit() {
        Graph graph = this.getGraph();
        Dimension d = this.getSize();
        if (graph != null && d != null) {
            this.currentIteration = 0;
            this.temperature = d.getWidth() / 10.0;
            this.forceConstant = Math.sqrt(d.getHeight() * d.getWidth() / (double)graph.getVertexCount());
            this.attraction_constant = this.attraction_multiplier * this.forceConstant;
            this.repulsion_constant = this.repulsion_multiplier * this.forceConstant;
        }
    }

    @Override
    public synchronized void step() {
        ++this.currentIteration;
        while (true) {
            try {
                for (Object v1 : this.getGraph().getVertices()) {
                    this.calcRepulsion(v1);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object e : this.getGraph().getEdges()) {
                    this.calcAttraction(e);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    if (this.isLocked(v)) continue;
                    this.calcPositions(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.cool();
    }

    protected synchronized void calcPositions(V v) {
        Point2D fvd = this.frVertexData.getUnchecked(v);
        if (fvd == null) {
            return;
        }
        Object xyd = this.apply((Object)v);
        double deltaLength = Math.max(this.EPSILON, Math.sqrt(fvd.getX() * fvd.getX() + fvd.getY() * fvd.getY()));
        double newXDisp = fvd.getX() / deltaLength * Math.min(deltaLength, this.temperature);
        Preconditions.checkState(!Double.isNaN(newXDisp), "Unexpected mathematical result in FRLayout:calcPositions [xdisp]");
        double newYDisp = fvd.getY() / deltaLength * Math.min(deltaLength, this.temperature);
        double newX = ((Point2D)xyd).getX() + Math.max(-5.0, Math.min(5.0, newXDisp));
        double newY = ((Point2D)xyd).getY() + Math.max(-5.0, Math.min(5.0, newYDisp));
        newX = Math.max(this.innerBounds.getMinX(), Math.min(newX, this.innerBounds.getMaxX()));
        newY = Math.max(this.innerBounds.getMinY(), Math.min(newY, this.innerBounds.getMaxY()));
        ((Point2D)xyd).setLocation(newX, newY);
    }

    protected void calcAttraction(E e) {
        Pair endpoints = this.getGraph().getEndpoints(e);
        Object v1 = endpoints.getFirst();
        Object v2 = endpoints.getSecond();
        boolean v1_locked = this.isLocked(v1);
        boolean v2_locked = this.isLocked(v2);
        if (v1_locked && v2_locked) {
            return;
        }
        Object p1 = this.apply(v1);
        Object p2 = this.apply(v2);
        if (p1 == null || p2 == null) {
            return;
        }
        double xDelta = ((Point2D)p1).getX() - ((Point2D)p2).getX();
        double yDelta = ((Point2D)p1).getY() - ((Point2D)p2).getY();
        double deltaLength = Math.max(this.EPSILON, ((Point2D)p1).distance((Point2D)p2));
        double force = deltaLength / this.attraction_constant;
        Preconditions.checkState(!Double.isNaN(force), "Unexpected mathematical result in FRLayout:calcPositions [force]");
        double dx = xDelta * force;
        double dy = yDelta * force;
        Point2D fvd1 = this.frVertexData.getUnchecked(v1);
        Point2D fvd2 = this.frVertexData.getUnchecked(v2);
        if (v2_locked) {
            fvd1.setLocation(fvd1.getX() - 2.0 * dx, fvd1.getY() - 2.0 * dy);
        } else {
            fvd1.setLocation(fvd1.getX() - dx, fvd1.getY() - dy);
        }
        if (v1_locked) {
            fvd2.setLocation(fvd2.getX() + 2.0 * dx, fvd2.getY() + 2.0 * dy);
        } else {
            fvd2.setLocation(fvd2.getX() + dx, fvd2.getY() + dy);
        }
    }

    protected void calcRepulsion(V v1) {
        Point2D fvd1 = this.frVertexData.getUnchecked(v1);
        if (fvd1 == null) {
            return;
        }
        fvd1.setLocation(0.0, 0.0);
        boolean v1_locked = this.isLocked(v1);
        try {
            for (Object v2 : this.getGraph().getVertices()) {
                boolean v2_locked = this.isLocked(v2);
                if (v1_locked && v2_locked || v1 == v2) continue;
                Object p1 = this.apply((Object)v1);
                Object p2 = this.apply(v2);
                if (p1 == null || p2 == null) continue;
                double xDelta = ((Point2D)p1).getX() - ((Point2D)p2).getX();
                double yDelta = ((Point2D)p1).getY() - ((Point2D)p2).getY();
                double deltaLength = Math.max(this.EPSILON, ((Point2D)p1).distanceSq((Point2D)p2));
                double force = this.repulsion_constant * this.repulsion_constant;
                double forceOverDeltaLength = force / deltaLength;
                Preconditions.checkState(!Double.isNaN(force), "Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                if (v2_locked) {
                    fvd1.setLocation(fvd1.getX() + 2.0 * xDelta * forceOverDeltaLength, fvd1.getY() + 2.0 * yDelta * forceOverDeltaLength);
                    continue;
                }
                fvd1.setLocation(fvd1.getX() + xDelta * forceOverDeltaLength, fvd1.getY() + yDelta * forceOverDeltaLength);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calcRepulsion(v1);
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        if (this.currentIteration > this.maxIterations || this.temperature < 1.0 / this.max_dimension) {
            if (!this.checked) {
                this.checked = true;
            }
            return true;
        }
        return false;
    }
}

