/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.io.Serializable;
import java.util.Collection;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.automata.ShrinkableAutomaton;
import net.automatalib.automata.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automata.base.fast.AbstractFastState;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.automata.concepts.StateLocalInput;
import net.automatalib.commons.util.mappings.ArrayMapping;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.commons.util.nid.AbstractMutableNumericID;
import net.automatalib.commons.util.nid.DynamicList;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractFastMutable<S extends AbstractFastState<?>, I, T, SP, TP>
implements ShrinkableAutomaton<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S>,
SupportsGrowingAlphabet<I>,
StateLocalInput<S, I>,
Serializable {
    protected final Alphabet<I> inputAlphabet;
    private final DynamicList<S> states = new DynamicList();
    private final transient IDChangeNotifier<S> tracker = new IDChangeNotifier();

    public AbstractFastMutable(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    @Override
    public int getStateId(S state) {
        return ((AbstractMutableNumericID)state).getId();
    }

    @Override
    public S getState(int id) {
        return (S)((AbstractFastState)this.states.get(id));
    }

    @Override
    public S addState(@Nullable SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    @Override
    public void removeAllTransitions(S state) {
        ((AbstractFastState)state).clearTransitionObjects();
    }

    protected abstract S createState(@Nullable SP var1);

    @Override
    public void removeState(S state, @Nullable S replacement) {
        ShrinkableAutomaton.unlinkState(this, state, replacement, this.inputAlphabet);
        this.states.remove(state, this.tracker);
    }

    @Override
    public void clear() {
        this.states.clear();
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        ArrayMapping<K, @Nullable V> mapping = new ArrayMapping(this.size());
        this.tracker.addListener(mapping, true);
        return mapping;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        int newAlphabetSize = this.inputAlphabet.size();
        for (AbstractFastState s2 : this.getStates()) {
            s2.ensureInputCapacity(newAlphabetSize);
        }
    }

    @Override
    public Collection<S> getStates() {
        return this.states;
    }

    @Override
    public StateIDs<S> stateIDs() {
        return this;
    }
}

