/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.vpda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.automata.vpda.StackContents;
import net.automatalib.automata.vpda.State;
import net.automatalib.graphs.Graph;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.VPDAlphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractOneSEVPA<L, I>
implements OneSEVPA<L, I>,
Graph<L, SevpaViewEdge<L, I>> {
    protected final VPDAlphabet<I> alphabet;

    public AbstractOneSEVPA(VPDAlphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    public VPDAlphabet<I> getAlphabet() {
        return this.alphabet;
    }

    @Override
    public @Nullable State<L> getTransition(State<L> state, I input) {
        L loc = state.getLocation();
        VPDAlphabet.SymbolType type = this.alphabet.getSymbolType(input);
        switch (type) {
            case CALL: {
                int newStackElem = this.encodeStackSym(loc, input);
                return new State(this.getInitialLocation(), StackContents.push(newStackElem, state.getStackContents()));
            }
            case RETURN: {
                StackContents contents = state.getStackContents();
                if (contents == null) {
                    return null;
                }
                int stackElem = contents.peek();
                L succ = this.getReturnSuccessor(loc, input, stackElem);
                if (succ == null) {
                    return null;
                }
                return new State<L>(succ, contents.pop());
            }
            case INTERNAL: {
                L succ = this.getInternalSuccessor(loc, input);
                if (succ == null) {
                    return null;
                }
                return new State<L>(succ, state.getStackContents());
            }
        }
        throw new IllegalStateException("Unknown symbol type " + (Object)((Object)type));
    }

    @Override
    public int encodeStackSym(L srcLoc, I callSym) {
        return this.encodeStackSym(srcLoc, this.alphabet.getCallSymbolIndex(callSym));
    }

    @Override
    public int encodeStackSym(L srcLoc, int callSymIdx) {
        return this.alphabet.getNumCalls() * this.getLocationId(srcLoc) + callSymIdx;
    }

    @Override
    public int getNumStackSymbols() {
        return this.size() * this.alphabet.getNumCalls();
    }

    @Override
    public abstract int size();

    @Override
    public Collection<L> getNodes() {
        return Collections.unmodifiableCollection(this.getLocations());
    }

    @Override
    public Collection<SevpaViewEdge<L, I>> getOutgoingEdges(L location) {
        ArrayList<SevpaViewEdge<L, I>> result = new ArrayList<SevpaViewEdge<L, I>>();
        for (Object i : this.alphabet.getInternalAlphabet()) {
            L succ = this.getInternalSuccessor(location, i);
            if (succ == null) continue;
            result.add(new SevpaViewEdge(i, -1, succ));
        }
        for (Object i : this.alphabet.getReturnAlphabet()) {
            for (Object loc : this.getLocations()) {
                for (Object stackSymbol : this.alphabet.getCallAlphabet()) {
                    int sym = this.encodeStackSym(loc, stackSymbol);
                    L succ = this.getReturnSuccessor(location, i, sym);
                    if (succ == null) continue;
                    result.add(new SevpaViewEdge(i, sym, succ));
                }
            }
        }
        return result;
    }

    @Override
    public L getTarget(SevpaViewEdge<L, I> edge) {
        return (L)edge.target;
    }

    @Override
    public VisualizationHelper<L, SevpaViewEdge<L, I>> getVisualizationHelper() {
        return new DefaultVisualizationHelper<L, SevpaViewEdge<L, I>>(){

            @Override
            protected Collection<L> initialNodes() {
                return Collections.singleton(AbstractOneSEVPA.this.getInitialLocation());
            }

            @Override
            public boolean getNodeProperties(L node, Map<String, String> properties) {
                super.getNodeProperties(node, properties);
                properties.put("shape", AbstractOneSEVPA.this.isAcceptingLocation(node) ? "doublecircle" : "circle");
                properties.put("label", "L" + AbstractOneSEVPA.this.getLocationId(node));
                return true;
            }

            @Override
            public boolean getEdgeProperties(L src, SevpaViewEdge<L, I> edge, L tgt, Map<String, String> properties) {
                Object input = edge.input;
                int stack = edge.stack;
                if (AbstractOneSEVPA.this.alphabet.isInternalSymbol(input)) {
                    properties.put("label", String.valueOf(input));
                } else if (AbstractOneSEVPA.this.alphabet.isReturnSymbol(input)) {
                    properties.put("label", input + "/(L" + AbstractOneSEVPA.this.getLocationId(AbstractOneSEVPA.this.getStackLoc(stack)) + ',' + AbstractOneSEVPA.this.getCallSym(stack) + ')');
                } else {
                    throw new IllegalArgumentException();
                }
                return true;
            }
        };
    }

    public L getStackLoc(int stackSym) {
        return this.getLocation(stackSym / this.alphabet.getNumCalls());
    }

    public I getCallSym(int stackSym) {
        return this.alphabet.getCallSymbol(stackSym % this.alphabet.getNumCalls());
    }

    static class SevpaViewEdge<S, I> {
        final I input;
        final int stack;
        final S target;

        SevpaViewEdge(I input, int stack, S target) {
            this.target = target;
            this.input = input;
            this.stack = stack;
        }
    }
}

