/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import net.automatalib.commons.util.strings.AbstractPrintable;
import net.automatalib.commons.util.strings.StringUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Pair<T1, T2>
extends AbstractPrintable
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final T1 first;
    private final T2 second;

    private Pair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    @Override
    public void print(Appendable a) throws IOException {
        StringUtil.appendObject(a, this.first);
        a.append(", ");
        StringUtil.appendObject(a, this.second);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.first);
        result = 31 * result + Objects.hashCode(this.second);
        return result;
    }
}

