/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.concurrent;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ScalingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicInteger activeCount = new AtomicInteger();

    public ScalingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new ScalingLinkedBlockingQueue());
        ((ScalingLinkedBlockingQueue)this.getQueue()).setTpe(this);
        this.setRejectedExecutionHandler(new ForceEnqueuingHandler());
    }

    @Override
    public int getActiveCount() {
        return this.activeCount.get();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.activeCount.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.activeCount.decrementAndGet();
    }

    static class ForceEnqueuingHandler
    implements RejectedExecutionHandler {
        ForceEnqueuingHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }

    static class ScalingLinkedBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = 7063154517431823515L;
        private transient ThreadPoolExecutor tpe;

        ScalingLinkedBlockingQueue() {
        }

        void setTpe(ThreadPoolExecutor tpe) {
            this.tpe = tpe;
        }

        @Override
        public boolean offer(Runnable r) {
            if (this.tpe.getActiveCount() + this.size() < this.tpe.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(r);
        }
    }
}

