/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.automata.concepts.InputAlphabetHolder;
import net.automatalib.incremental.mealy.tree.AbstractIncrementalMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.AnnotatedEdge;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.incremental.mealy.tree.Node;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public class IncrementalMealyTreeBuilder<I, O>
extends AbstractIncrementalMealyTreeBuilder<Node<O>, I, O>
implements InputAlphabetHolder<I> {
    private final Alphabet<I> inputAlphabet;
    private int alphabetSize;

    public IncrementalMealyTreeBuilder(Alphabet<I> inputAlphabet) {
        super(new Node(inputAlphabet.size()));
        this.inputAlphabet = inputAlphabet;
        this.alphabetSize = inputAlphabet.size();
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        int newAlphabetSize;
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.inputAlphabet.size())) {
            this.ensureInputCapacity((Node)this.root, this.alphabetSize, newAlphabetSize);
            this.alphabetSize = newAlphabetSize;
        }
    }

    private void ensureInputCapacity(Node<O> node, int oldAlphabetSize, int newAlphabetSize) {
        node.ensureInputCapacity(newAlphabetSize);
        for (int i = 0; i < oldAlphabetSize; ++i) {
            Node<O> child = node.getSuccessor(i);
            if (child == null) continue;
            this.ensureInputCapacity(child, oldAlphabetSize, newAlphabetSize);
        }
    }

    @Override
    protected Edge<Node<O>, O> getEdge(Node<O> node, I symbol) {
        return node.getEdge(this.inputAlphabet.getSymbolIndex(symbol));
    }

    @Override
    protected Node<O> createNode() {
        return new Node(this.alphabetSize);
    }

    @Override
    protected Node<O> insertNode(Node<O> parent, I symIdx, O output) {
        Object succ = this.createNode();
        Edge<Object, O> edge = new Edge<Object, O>(output, succ);
        parent.setEdge(this.inputAlphabet.getSymbolIndex(symIdx), edge);
        return succ;
    }

    @Override
    protected Collection<AnnotatedEdge<Node<O>, I, O>> getOutgoingEdges(Node<O> node) {
        ArrayList<AnnotatedEdge<Node<O>, I, O>> result = new ArrayList<AnnotatedEdge<Node<O>, I, O>>(this.alphabetSize);
        for (int i = 0; i < this.alphabetSize; ++i) {
            Edge<Node<O>, O> edge = node.getEdge(i);
            if (edge == null) continue;
            result.add(new AnnotatedEdge<Node<O>, I, O>(edge, this.inputAlphabet.getSymbol(i)));
        }
        return result;
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }
}

