/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.equivalence;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DeterministicEquivalenceTest<I> {
    private static final int MAP_THRESHOLD = 10000;
    private final UniversalDeterministicAutomaton<?, I, ?, ?, ?> reference;

    public DeterministicEquivalenceTest(UniversalDeterministicAutomaton<?, I, ?, ?, ?> reference) {
        this.reference = reference;
    }

    public @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<?, I, ?, ?, ?> other, Collection<? extends I> inputs) {
        return DeterministicEquivalenceTest.findSeparatingWord(this.reference, other, inputs);
    }

    public static <I, S, T, SP, TP, S2, T2, SP2, TP2> @Nullable Word<I> findSeparatingWord(UniversalDeterministicAutomaton<S, I, T, SP, TP> reference, UniversalDeterministicAutomaton<S2, I, T2, SP2, TP2> other, Collection<? extends I> inputs) {
        StatePair currPair;
        Object otherStateProp;
        int refSize = reference.size();
        int totalStates = refSize * other.size();
        if (totalStates < 0 || totalStates > 10000) {
            return DeterministicEquivalenceTest.findSeparatingWordLarge(reference, other, inputs);
        }
        Object refInit = reference.getInitialState();
        Object otherInit = other.getInitialState();
        if (refInit == null || otherInit == null) {
            return refInit == null && otherInit == null ? null : Word.epsilon();
        }
        Object refStateProp = reference.getStateProperty(refInit);
        if (!Objects.equals(refStateProp, otherStateProp = other.getStateProperty(otherInit))) {
            return Word.epsilon();
        }
        ArrayDeque bfsQueue = new ArrayDeque();
        bfsQueue.add(new StatePair(refInit, otherInit));
        StateIDs refStateIds = reference.stateIDs();
        StateIDs<Object> otherStateIds = other.stateIDs();
        int lastId = otherStateIds.getStateId(otherInit) * refSize + refStateIds.getStateId(refInit);
        Pred[] preds = new Pred[totalStates];
        preds[lastId] = new Pred();
        int currDepth = 0;
        int inCurrDepth = 1;
        int inNextDepth = 0;
        Object lastSym = null;
        block0: while ((currPair = (StatePair)bfsQueue.poll()) != null) {
            int currId;
            Object refState = currPair.ref;
            Object otherState = currPair.other;
            lastId = currId = otherStateIds.getStateId(otherState) * refSize + refStateIds.getStateId(refState);
            for (I in : inputs) {
                Object otherProp;
                lastSym = in;
                Object refTrans = reference.getTransition(refState, in);
                Object otherTrans = other.getTransition(otherState, in);
                if (refTrans == null || otherTrans == null) {
                    if (refTrans != null || otherTrans != null) break block0;
                    continue;
                }
                Object refProp = reference.getTransitionProperty(refTrans);
                if (!Objects.equals(refProp, otherProp = other.getTransitionProperty(otherTrans))) break block0;
                Object refSucc = reference.getSuccessor(refTrans);
                Object otherSucc = other.getSuccessor(otherTrans);
                int succId = otherStateIds.getStateId(otherSucc) * refSize + refStateIds.getStateId(refSucc);
                if (preds[succId] != null) continue;
                refStateProp = reference.getStateProperty(refSucc);
                if (!Objects.equals(refStateProp, otherStateProp = other.getStateProperty(otherSucc))) break block0;
                preds[succId] = new Pred<I>(currId, in);
                bfsQueue.add(new StatePair(refSucc, otherSucc));
                ++inNextDepth;
            }
            lastSym = null;
            if (--inCurrDepth != 0) continue;
            inCurrDepth = inNextDepth;
            inNextDepth = 0;
            ++currDepth;
        }
        if (lastSym == null) {
            return null;
        }
        WordBuilder<Object> sep = new WordBuilder<Object>(null, currDepth + 1);
        int index = currDepth;
        sep.setSymbol(index--, lastSym);
        Pred pred = preds[lastId];
        while (pred.id >= 0) {
            sep.setSymbol(index--, pred.symbol);
            pred = preds[pred.id];
        }
        return sep.toWord();
    }

    public static <I, S, T, SP, TP, S2, T2, SP2, TP2> @Nullable Word<I> findSeparatingWordLarge(UniversalDeterministicAutomaton<S, I, T, SP, TP> reference, UniversalDeterministicAutomaton<S2, I, T2, SP2, TP2> other, Collection<? extends I> inputs) {
        StatePair currPair;
        Object otherStateProp;
        Object refInit = reference.getInitialState();
        Object otherInit = other.getInitialState();
        if (refInit == null || otherInit == null) {
            return refInit == null && otherInit == null ? null : Word.epsilon();
        }
        Object refStateProp = reference.getStateProperty(refInit);
        if (!Objects.equals(refStateProp, otherStateProp = other.getStateProperty(otherInit))) {
            return Word.epsilon();
        }
        ArrayDeque bfsQueue = new ArrayDeque();
        bfsQueue.add(new StatePair(refInit, otherInit));
        int refSize = reference.size();
        StateIDs refStateIds = reference.stateIDs();
        StateIDs<Object> otherStateIds = other.stateIDs();
        int lastId = otherStateIds.getStateId(otherInit) * refSize + refStateIds.getStateId(refInit);
        HashMap<Integer, Pred<I>> preds = new HashMap<Integer, Pred<I>>();
        preds.put(lastId, new Pred());
        int currDepth = 0;
        int inCurrDepth = 1;
        int inNextDepth = 0;
        Object lastSym = null;
        block0: while ((currPair = (StatePair)bfsQueue.poll()) != null) {
            int currId;
            Object refState = currPair.ref;
            Object otherState = currPair.other;
            lastId = currId = otherStateIds.getStateId(otherState) * refSize + refStateIds.getStateId(refState);
            for (I in : inputs) {
                Object otherProp;
                lastSym = in;
                Object refTrans = reference.getTransition(refState, in);
                Object otherTrans = other.getTransition(otherState, in);
                if (refTrans == null || otherTrans == null) {
                    if (refTrans != null || otherTrans != null) break block0;
                    continue;
                }
                Object refProp = reference.getTransitionProperty(refTrans);
                if (!Objects.equals(refProp, otherProp = other.getTransitionProperty(otherTrans))) break block0;
                Object refSucc = reference.getSuccessor(refTrans);
                Object otherSucc = other.getSuccessor(otherTrans);
                int succId = otherStateIds.getStateId(otherSucc) * refSize + refStateIds.getStateId(refSucc);
                if (preds.get(succId) != null) continue;
                refStateProp = reference.getStateProperty(refSucc);
                if (!Objects.equals(refStateProp, otherStateProp = other.getStateProperty(otherSucc))) break block0;
                preds.put(succId, new Pred<I>(currId, in));
                bfsQueue.add(new StatePair(refSucc, otherSucc));
                ++inNextDepth;
            }
            lastSym = null;
            if (--inCurrDepth != 0) continue;
            inCurrDepth = inNextDepth;
            inNextDepth = 0;
            ++currDepth;
        }
        if (lastSym == null) {
            return null;
        }
        WordBuilder<Object> sep = new WordBuilder<Object>(null, currDepth + 1);
        int index = currDepth;
        sep.setSymbol(index--, lastSym);
        Pred pred = (Pred)preds.get(lastId);
        assert (pred != null);
        while (pred.id >= 0) {
            sep.setSymbol(index--, pred.symbol);
            pred = (Pred)preds.get(pred.id);
            assert (pred != null);
        }
        return sep.toWord();
    }

    private static final class Pred<I> {
        public final int id;
        public final I symbol;

        Pred() {
            this.id = -1;
            this.symbol = null;
        }

        Pred(int id, I input) {
            this.id = id;
            this.symbol = input;
        }
    }

    private static final class StatePair<S, S2> {
        public final S ref;
        public final S2 other;

        StatePair(S ref, S2 other) {
            this.ref = ref;
            this.other = other;
        }
    }
}

