package de.renew.appleui;

import de.renew.gui.GuiPlugin;
import de.renew.plugin.IPlugin;
import de.renew.plugin.SoftDependencyListener;


/**
 * Connects to the "Renew Gui" plugin if available.
 *
 * @author Michael Duvigneau
 **/
public class GuiDependencyListener implements SoftDependencyListener, AboutDisplayer {
    private AppleUI _applePlugin;
    private GuiPlugin _guiPlugin;

    /**
     * Listener for the GuiDependencies
     *
     * @param applePlugin AppleUI which should be used
     */
    public GuiDependencyListener(IPlugin applePlugin) {
        this._applePlugin = (AppleUI) applePlugin;
    }

    /**
     * Clears the about box displayer info.
     *
     * @param plugin {@inheritDoc}
     **/
    @Override
    public final void serviceRemoved(final IPlugin plugin) {
        _applePlugin.setAboutDisplayer(null);
        this._guiPlugin = null;
    }

    /**
     * Registers this object as about box displayer.
     * @param plugin {@inheritDoc}
     **/
    @Override
    public final void serviceAvailable(final IPlugin plugin) {
        this._guiPlugin = (GuiPlugin) plugin;
        _applePlugin.setAboutDisplayer(this);
    }

    @Override
    public void displayAboutBox() {
        if (_guiPlugin != null) {
            _guiPlugin.createAboutBox().setVisible(true);
        }
    }

    @Override
    public void bringMenuFrameToFront() {
        if (_guiPlugin != null) {
            _guiPlugin.bringMenuFrameToFront();
        }
    }
}