package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Command;


/**
 * A command that opens drawing from a file in the editor.
 *
 * @author Michael Duvigneau
 **/
public class OpenDrawingCommand extends Command {
    private String path = null;

    /**
     * Creates a new OpenDrawingCommand containing the default message.
     */
    public OpenDrawingCommand() {
        super("Open Drawing...");
    }

    /**
     * Creates a new OpenDrawingCommand containing a custom message.
     * @param name String that contains the name of the command
     * @param path String that contains the path of the command
     */
    public OpenDrawingCommand(String path, String name) {
        super(name);
        this.path = path;
    }


    /**
     * This command is always executable.
     * <p>
     * It is of course not executable when there is no gui open, but then
     * the command is not accessible, either.
     * </p>
     * @return always <code>true</code>
     **/
    @Override
    public final boolean isExecutable() {
        return true;
    }

    /**
     * Opens a drawing from a file.
     **/
    @Override
    public final void execute() {
        if (path == null) {
            DrawPlugin.getGui().promptOpen(DrawPlugin.getCurrent().getIOHelper().getFileFilter());
        } else {
            DrawPlugin.getGui().openOrLoadDrawing(path);

        }
    }
}