/*
 * @(#)BorderTool.java 5.1
 *
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ActionTool;

/**
 * BorderTool decorates the clicked figure with a BorderDecorator.
 * <p>
 * The current implementation is not undoable.
 * (The class is currently not in use.)
 *
 * {@link BorderDecorator}
 */
public class BorderTool extends ActionTool {
    /**
     * Constructs a new BorderTool.
     *
     * @param editor {@code DrawingEditor} to manage the drawing process
     */
    public BorderTool(DrawingEditor editor) {
        super(editor);
    }

    /**
     * Decorates the clicked figure with a border.
     */
    @Override
    public void action(Figure figure) {
        drawing().replace(figure, new BorderDecorator(figure));
    }
}